%define oname keystone
%define without tests
%define without doc
Name: openstack-%oname
Epoch: 1
Version: 23.0.0
Release: alt1.p10

Summary: OpenStack Identity Service

Group: System/Servers
License: Apache-2.0
Url: http://docs.openstack.org/developer/%oname

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz

Source1: %name.logrotate
Source3: %name.sysctl
Source4: %name.tmpfiles
Source5: %name.conf
Source6: %name.start

BuildArch: noarch

Requires(pre): python3-module-keystone = %EVR
Requires: python3-module-keystoneclient = 5.1.0
Requires: python3-module-pymysql
Requires: apache2-mod_wsgi-py3
Requires: /usr/bin/uuidgen

Requires(pre): shadow-utils

BuildRequires(pre): rpm-macros-apache2
BuildRequires: webserver-common
BuildRequires: rpm-build-webserver-common
BuildRequires: crudini

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-wheel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-webob >= 1.7.1
BuildRequires: python3-module-flask >= 1.0.2
BuildRequires: python3-module-flask-restful >= 0.3.5
BuildRequires: python3-module-cryptography >= 2.7
BuildRequires: python3-module-sqlalchemy >= 1.3.0
BuildRequires: python3-module-migrate >= 0.13.0
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-passlib >= 1.7.0
BuildRequires: python3-module-keystoneclient >= 3.8.0
BuildRequires: python3-module-keystonemiddleware >= 7.0.0
BuildRequires: python3-module-bcrypt >= 3.1.3
BuildRequires: python3-module-scrypt >= 0.8.0
BuildRequires: python3-module-oslo.cache >= 1.26.0
BuildRequires: python3-module-oslo.config >= 6.8.0
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.messaging >= 5.29.0
BuildRequires: python3-module-oslo.db >= 6.0.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.log >= 3.44.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-oslo.policy >= 3.10.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-oauthlib >= 0.6.2
BuildRequires: python3-module-pysaml2 >= 5.0.0
BuildRequires: python3-module-jwt >= 1.6.1
BuildRequires: python3-module-dogpile.cache >= 1.0.2
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-pycadf >= 1.1.0
BuildRequires: python3-module-msgpack >= 0.5.0
BuildRequires: python3-module-osprofiler >= 1.4.0
BuildRequires: python3-module-pytz >= 2013.6

%if_with tests
BuildRequires: python3-module-hacking ~= 4.1.0
BuildRequires: python3-module-flake8-docstrings ~= 1.6.0
BuildRequires: python3-module-bashate >= 0.5.1
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-freezegun >= 0.3.6
BuildRequires: python3-module-pytz >= 2013.6
BuildRequires: python3-module-oslo.db-tests >= 6.0.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-lxml >= 4.5.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-webtest >= 2.0.27
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-tempest >= 17.1.0
BuildRequires: python3-module-requests >= 2.14.2
%endif

%if_with doc
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-sphinxcontrib-apidoc >= 0.2.0
BuildRequires: python3-module-sphinxcontrib-seqdiag >= 0.8.4
BuildRequires: python3-module-sphinx-feature-classification >= 0.3.2
BuildRequires: python3-module-sphinxcontrib-blockdiag >= 1.5.5
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-os-api-ref >= 1.4.0
BuildRequires: python3-module-ldap >= 3.0.0
BuildRequires: python3-module-ldappool >= 2.0.0
%endif

%add_python_req_skip xmldsig

%description
Keystone is a Python implementation of the OpenStack
(http://www.openstack.org) identity service API.

This package contains the Keystone daemon.

%package -n python3-module-%oname
Summary: Keystone Python libraries
Group: Development/Python3

Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-webob >= 1.7.1
Requires: python3-module-flask >= 1.0.2
Requires: python3-module-flask-restful >= 0.3.5
Requires: python3-module-cryptography >= 2.7
Requires: python3-module-sqlalchemy >= 1.3.0
Requires: python3-module-migrate >= 0.13.0
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-passlib >= 1.7.0
Requires: python3-module-keystoneclient = 5.1.0
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-bcrypt >= 3.1.3
Requires: python3-module-scrypt >= 0.8.0
Requires: python3-module-oslo.cache >= 3.3.0 python3-module-oslo.cache <= 3.3.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oauthlib >= 0.6.2
Requires: python3-module-pysaml2 >= 5.0.0
Requires: python3-module-jwt >= 1.6.1
Requires: python3-module-dogpile.cache >= 1.0.2
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-pycadf >= 1.1.0
Requires: python3-module-msgpack >= 0.5.0
Requires: python3-module-osprofiler >= 1.4.0
Requires: python3-module-pytz >= 2013.6

%description -n python3-module-%oname
Keystone is a Python implementation of the OpenStack
(http://www.openstack.org) identity service API.

This package contains the Keystone Python library.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%if_with doc
%package doc
Summary: Documentation for OpenStack Identity Service
Group: Development/Documentation

%description doc
Keystone is a Python implementation of the OpenStack
(http://www.openstack.org) identity service API.

This package contains documentation for Keystone.
%endif

%prep
%setup -n %oname-%version

find . \( -name .gitignore -o -name .placeholder \) -delete
find keystone -name \*.py -exec sed -i '/\/usr\/bin\/env python/d' {} \;

# Let RPM handle the dependencies
rm -f test-requirements.txt requirements.txt

%build
%pyproject_build

PYTHONPATH=. oslo-config-generator --config-file=config-generator/keystone.conf
PYTHONPATH=. oslo-config-generator --config-file=config-generator/keystone-policy-generator.conf

%if_with doc
python3 setup.py build_sphinx
rm -rf build/sphinx/html/.buildinfo
sphinx-build-3 -b man doc/source doc/build/man
%endif

%install
%pyproject_install

install -d -m 755 %buildroot%_sysconfdir/keystone
install -d -m 755 %buildroot%_sysconfdir/keystone/keystone.conf.d/
install -d -m 770 %buildroot%_sysconfdir/keystone/credential-keys/
install -p -D -m 640 etc/keystone.conf.sample %buildroot%_sysconfdir/keystone/keystone.conf
install -p -D -m 640 etc/keystone.policy.yaml.sample %buildroot%_sysconfdir/keystone/keystone.policy.yaml
install -p -D -m 640 etc/logging.conf.sample %buildroot%_sysconfdir/keystone/logging.conf
install -p -D -m 644 etc/default_catalog.templates %buildroot%_sysconfdir/keystone/default_catalog.templates
install -p -D -m 644 etc/sso_callback_template.html %buildroot%_sysconfdir/keystone/sso_callback_template.html
install -p -D -m 644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/openstack-keystone
install -d -m 755 %buildroot%_sysctldir
install -p -D -m 644 %SOURCE3 %buildroot%_sysctldir/openstack-keystone.conf
install -d -m 755 %buildroot%_tmpfilesdir
install -p -D -m 644 %SOURCE4 %buildroot%_tmpfilesdir/openstack-keystone.conf

install -m 0644 -D -p %SOURCE5 %buildroot%apache2_sites_available/openstack-keystone.conf
install -m 0644 -D -p %SOURCE6 %buildroot%apache2_sites_start/100-openstack-keystone.conf

mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/openstack-keystone.conf

install -d -m 755 %buildroot%_sharedstatedir/keystone
install -d -m 755 %buildroot%_sharedstatedir/keystone/cache
install -d -m 750 %buildroot%_logdir/keystone
install -d -m 755 %buildroot%_runtimedir/keystone

%if_with doc
mkdir -p %buildroot%_man1dir
install -p -D -m 644 doc/build/man/*.1 %buildroot%_man1dir/
%endif

# create keystone ssl dirs
install -d %buildroot%_sysconfdir/keystone/ssl/private
touch %buildroot%_sysconfdir/keystone/ssl/private/signing_key.pem
install -d %buildroot%_sysconfdir/keystone/ssl/certs
touch %buildroot%_sysconfdir/keystone/ssl/certs/signing_cert.pem

### set default configuration
%define keystone_conf %buildroot%_sysconfdir/keystone/keystone.conf.d/010-keystone.conf
crudini --set %keystone_conf DEFAULT log_dir /var/log/keystone

# cleanup
rm -rf %buildroot/usr/etc

%pre
# 163:163 for keystone (openstack-keystone)
%_sbindir/groupadd -r -g 163 -f keystone 2>/dev/null ||:
%_sbindir/useradd -r -u 163 -g keystone -c 'OpenStack Keystone Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/keystone keystone 2>/dev/null ||:

%_sbindir/a2enmod wsgi-py3

%post
keystone-manage fernet_setup --keystone-user keystone --keystone-group keystone
keystone-manage credential_setup --keystone-user keystone --keystone-group keystone
# keystone-manage will create a keystone.log file owned by root; fix that
if [ -f %_logdir/keystone/keystone-manage.log ]; then
    chown keystone:keystone %_logdir/keystone/keystone-manage.log
fi

#%preun
#%preun_service %name

%files
%doc LICENSE
%doc README.rst
%doc tools/sample_data.sh
%doc httpd/*
%config(noreplace) %apache2_sites_available/*.conf
%apache2_sites_start/*.conf
%ghost %apache2_sites_enabled/*.conf
%_tmpfilesdir/openstack-keystone.conf
%_bindir/keystone-status
%_bindir/keystone-wsgi-admin
%_bindir/keystone-wsgi-public
%dir %attr(0750, root, keystone) %_sysconfdir/keystone
%dir %attr(0750, root, keystone) %_sysconfdir/keystone/keystone.conf.d
%dir %attr(0770, root, keystone) %_sysconfdir/keystone/credential-keys
%dir %attr(0755, root, keystone) %_sysconfdir/keystone/ssl
%dir %attr(0755, root, keystone) %_sysconfdir/keystone/ssl/certs
%ghost %attr(0644, root, keystone) %_sysconfdir/keystone/ssl/certs/signing_cert.pem
%dir %attr(0750, root, keystone) %_sysconfdir/keystone/ssl/private
%ghost %attr(0640, root, keystone) %_sysconfdir/keystone/ssl/private/signing_key.pem
%config(noreplace) %attr(0640, root, keystone) %_sysconfdir/keystone/keystone.conf
%config(noreplace) %attr(0640, root, keystone) %_sysconfdir/keystone/keystone.conf.d/010-keystone.conf
%config(noreplace) %attr(0644, root, keystone) %_sysconfdir/keystone/logging.conf
%config %_sysconfdir/keystone/default_catalog.templates
%config %_sysconfdir/keystone/keystone.policy.yaml
%config %_sysconfdir/keystone/sso_callback_template.html
%config(noreplace) %_sysconfdir/logrotate.d/openstack-keystone
%dir %attr(0755, keystone, keystone) %_sharedstatedir/keystone
%dir %attr(0755, keystone, keystone) %_sharedstatedir/keystone/cache
%dir %attr(0750, keystone, keystone) %_logdir/keystone
%dir %attr(0755, keystone, keystone) %_runtimedir/keystone
%_sysctldir/openstack-keystone.conf

%files -n python3-module-%oname
%python3_sitelibdir/*
%_bindir/keystone-manage
%exclude %python3_sitelibdir/%oname/tests

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%if_with doc
%files doc
%doc LICENSE
build/sphinx/html
%endif

%changelog
