%define oname neutron
%def_without doc
%def_without tests

Name: openstack-%oname
Version: 22.1.0
Release: alt1.p10
Epoch: 1
Provides: openstack-quantum = %EVR
Obsoletes: openstack-quantum < 2013.2-0.4.b3
Summary: OpenStack Networking Service

Group: System/Servers
License: ASL 2.0
Url: http://docs.openstack.org/developer/%oname
Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz

Source1: neutron.logrotate
Source2: neutron-sudoers
Source3: %name.tmpfiles
Source5: neutron.sysconfig
Source6: neutron-enable-bridge-firewall.sh

Source10: neutron-server.service
Source11: neutron-linuxbridge-agent.service
Source12: neutron-openvswitch-agent.service
Source15: neutron-dhcp-agent.service
Source16: neutron-l3-agent.service
Source17: neutron-metadata-agent.service
Source18: neutron-ovs-cleanup.service
Source19: neutron-macvtap-agent.service
Source20: neutron-metering-agent.service
Source21: neutron-sriov-nic-agent.service
Source29: neutron-rpc-server.service

Source110: neutron-server.init
Source111: neutron-linuxbridge-agent.init
Source112: neutron-openvswitch-agent.init
Source115: neutron-dhcp-agent.init
Source116: neutron-l3-agent.init
Source117: neutron-metadata-agent.init
Source118: neutron-ovs-cleanup.init
Source119: neutron-macvtap-agent.init
Source120: neutron-metering-agent.init
Source121: neutron-sriov-nic-agent.init
Source129: neutron-rpc-server.init

BuildArch: noarch

Requires: python3-module-neutron = %EVR
Requires: python3-module-PasteDeploy
Requires: python3-module-oslo.rootwrap >= 5.8.0

Requires(pre): shadow-utils

Conflicts: %name-ml2 < %EVR

BuildRequires: crudini
BuildRequires: /proc

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 4.0.0
BuildRequires: python3-module-paste >= 2.0.2
BuildRequires: python3-module-PasteDeploy >= 1.5.0
BuildRequires: python3-module-routes >= 2.3.1
BuildRequires: python3-module-debtcollector >= 1.19.0
BuildRequires: python3-module-decorator >= 4.1.0
BuildRequires: python3-module-eventlet >= 0.26.1
BuildRequires: python3-module-pecan >= 1.4.0
BuildRequires: python3-module-httplib2 >= 0.9.1
BuildRequires: python3-module-requests >= 2.18.0
BuildRequires: python3-module-jinja2 >= 2.10
BuildRequires: python3-module-keystonemiddleware >= 5.1.0
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-netifaces >= 0.10.4
BuildRequires: python3-module-neutron-lib >= 3.4.0
BuildRequires: python3-module-neutronclient >= 7.8.0
BuildRequires: python3-module-tenacity >= 6.0.0
BuildRequires: python3-module-sqlalchemy >= 1.4.23
BuildRequires: python3-module-webob >= 1.8.2
BuildRequires: python3-module-keystoneauth1 >= 3.14.0
BuildRequires: python3-module-alembic >= 1.6.5
BuildRequires: python3-module-stevedore >= 2.0.1
BuildRequires: python3-module-oslo.cache >= 1.26.0
BuildRequires: python3-module-oslo.concurrency >= 3.26.0
BuildRequires: python3-module-oslo.config >= 9.0.0
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.db >= 4.44.0
BuildRequires: python3-module-oslo.i18n >= 3.20.0
BuildRequires: python3-module-oslo.log >= 4.5.0
BuildRequires: python3-module-oslo.messaging >= 7.0.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-oslo.policy >= 3.12.0
BuildRequires: python3-module-oslo.privsep >= 2.3.0
BuildRequires: python3-module-oslo.reports >= 1.18.0
BuildRequires: python3-module-oslo.rootwrap >= 5.15.0
BuildRequires: python3-module-oslo.serialization >= 2.25.0
BuildRequires: python3-module-oslo.service >= 2.8.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-oslo.utils >= 4.8.0
BuildRequires: python3-module-oslo.versionedobjects >= 1.35.1
BuildRequires: python3-module-osprofiler >= 2.3.0
BuildRequires: python3-module-os-ken >= 2.2.0
BuildRequires: python3-module-os-resource-classes >= 1.1.0
BuildRequires: python3-module-openvswitch >= 2.10.0
BuildRequires: python3-module-ovsdbapp = 2.2.1
BuildRequires: python3-module-packaging >= 20.4
BuildRequires: python3-module-psutil >= 5.3.0
BuildRequires: python3-module-pyroute2 >= 0.7.3
BuildRequires: python3-module-openssl >= 17.1.0
BuildRequires: python3-module-novaclient >= 9.1.0
BuildRequires: python3-module-openstacksdk >= 0.31.2
BuildRequires: python3-module-designateclient >= 2.7.0
BuildRequires: python3-module-os-vif >= 3.1.0
BuildRequires: python3-module-futurist >= 1.2.0
BuildRequires: python3-module-tooz >= 1.58.0

%if_with doc
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-sphinx-feature-classification >= 1.0.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-webtest >= 2.0.27
BuildRequires: python3-module-pyroute2 >= 0.6.4
%endif

%if_with tests
BuildRequires: python3-module-coverage >= 4.4
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-subunit >= 1.0.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-testresources >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-webtest >= 2.0.27
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-ddt >= 1.0.1
BuildRequires: python3-module-pymysql >= 0.7.6
%endif

%description
Neutron is a virtual network service for Openstack. Just like
OpenStack Nova provides an API to dynamically request and configure
virtual servers, Neutron provides an API to dynamically request and
configure virtual networks. These networks connect "interfaces" from
other OpenStack services (e.g., virtual NICs from Nova VMs). The
Neutron API supports extensions to provide advanced network
capabilities (e.g., QoS, ACLs, network monitoring, etc.)

%package -n python3-module-%oname
Summary: Neutron Python3 libraries
Group: Development/Python3

Provides: python3(neutron.common)

Requires: python3-module-pbr >= 4.0.0
Requires: python3-module-paste >= 2.0.2
Requires: python3-module-PasteDeploy >= 1.5.0
Requires: python3-module-routes >= 2.3.1
Requires: python3-module-debtcollector >= 1.19.0
Requires: python3-module-decorator >= 4.1.0
Requires: python3-module-eventlet >= 0.26.1
Requires: python3-module-pecan >= 1.4.0
Requires: python3-module-httplib2 >= 0.9.1
Requires: python3-module-requests >= 2.18.0
Requires: python3-module-jinja2 >= 2.10
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-netaddr >= 0.7.18
Requires: python3-module-netifaces >= 0.10.4
Requires: python3-module-neutron-lib >= 3.2.0 python3-module-neutron-lib <= 3.4.2
Requires: python3-module-neutronclient >= 8.2.0 python3-module-neutronclient <= 9.0.0
Requires: python3-module-tenacity >= 6.0.0
Requires: python3-module-sqlalchemy >= 1.4.23
Requires: python3-module-webob >= 1.8.2
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-alembic >= 1.6.5
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0
Requires: python3-module-oslo.cache >= 3.3.0 python3-module-oslo.cache <= 3.3.1
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.messaging >= 14.1.0 python3-module-oslo.messaging <= 14.2.2
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.privsep = 3.1.0
Requires: python3-module-oslo.reports = 3.0.0
Requires: python3-module-oslo.rootwrap >= 7.0.0 python3-module-oslo.rootwrap <= 7.0.1
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.service >= 3.1.0 python3-module-oslo.service <= 3.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.versionedobjects = 3.1.0
Requires: python3-module-osprofiler >= 2.3.0
Requires: python3-module-os-ken = 2.6.0
Requires: python3-module-os-resource-classes >= 1.1.0
Requires: python3-module-openvswitch >= 2.10.0
Requires: python3-module-ovsdbapp = 2.2.1
Requires: python3-module-packaging >= 20.4
Requires: python3-module-psutil >= 5.3.0
Requires: python3-module-pyroute2 >= 0.7.3
Requires: python3-module-openssl >= 17.1.0
Requires: python3-module-novaclient >= 18.2.0 python3-module-novaclient <= 18.3.0
Requires: python3-module-openstacksdk >= 0.102.0 python3-module-openstacksdk <= 1.0.1
Requires: python3-module-designateclient >= 5.1.0 python3-module-designateclient <= 5.2.0
Requires: python3-module-os-vif >= 3.1.0 python3-module-os-vif <= 3.1.1
Requires: python3-module-futurist >= 1.2.0
Requires: python3-module-tooz >= 1.58.0
Requires: sudo conntrack-tools

%description -n python3-module-%oname
Neutron provides an API to dynamically request and configure virtual
networks.

This package contains the neutron Python3 library.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%package server
Summary: OpenStack Network Neutron Server
Group: System/Servers
Requires: %name = %EVR
Provides: %name-rpc-server = %EVR
Obsoletes: %name-rpc-server < %EVR

%description server
This package provides the Neutron server

%package dhcp-agent
Summary: OpenStack Network - DHCP Agent
Group: Development/Python
Requires: %name = %EVR
Requires: dnsmasq dnsmasq-utils

%description dhcp-agent
This package provides the DHCP Agent.

%package linuxbridge-agent
Summary: OpenStack Network - Linux Bridge Agent
Group: Development/Python

Provides: openstack-quantum-linuxbridge = %EVR
Obsoletes: openstack-quantum-linuxbridge < 2013.2-0.4.b3
Provides: %name-linuxbridge = %EVR
Obsoletes: %name-linuxbridge < %EVR

Provides:  %name-agent = %EVR

Requires: bridge-utils
Requires: conntrack-tools
Requires: ebtables
Requires: ipset
Requires: iptables
Requires: kmod
Requires: %name = %EVR

%description linuxbridge-agent
Neutron provides an API to dynamically request and configure virtual
networks.

This package contains the neutron plugin that implements virtual
networks using Linux bridging.

%package l3-agent
Summary: OpenStack Network Service (Neutron) - L3 Agent
Group: Development/Python
Requires: %name = %EVR
Requires: conntrack-tools

%description l3-agent
This package provides the L3 Agent.

%package openvswitch-agent
Summary: OpenStack Network Service (Neutron) - Openvswitch Agent
Group: Development/Python
Provides: %name-openvswitch = %EVR
Obsoletes: %name-openvswitch < %EVR

Provides:  %name-agent = %EVR

Requires: %name = %EVR
Requires: openvswitch
Requires: python3-module-openvswitch
Requires: conntrack-tools
Requires: ipset
Requires: iptables
Requires: kmod

%description openvswitch-agent
Neutron provides an API to dynamically request and configure virtual
networks.

This package contains the neutron plugin that implements virtual
networks using Open vSwitch.

%package macvtap-agent
Summary: OpenStack Network - macvtap
Group: Development/Python
Requires: %name = %EVR

%description macvtap-agent
This package provides the macvtap Agent.

%package metadata-agent
Summary: OpenStack Network - Meta Data Agent
Group: Development/Python
Requires: %name = %EVR
Requires: haproxy

%description metadata-agent
This package provides the Meta Data Agent.

%package metering-agent
Summary: Neutron bandwidth metering agent
Group: Development/Python
Requires: %name = %EVR

%description metering-agent
Neutron provides an API to measure bandwidth utilization

This package contains the neutron agent responsible for generating bandwidth
utilization notifications.

%package sriov-nic-agent
Summary: Neutron SR-IOV NIC agent
Group: Development/Python
Requires: %name = %EVR

%description sriov-nic-agent
Neutron allows to run virtual instances using SR-IOV NIC hardware

This package contains the Neutron agent to support advanced features of
SR-IOV network cards.

%prep
%setup -n %oname-%version

find neutron -name \*.py -exec sed -i '/\/usr\/bin\/env python/{d;q}' {} +

# Let's handle dependencies ourseleves
rm -f requirements.txt

%build
export PBR_VERSION=%version
export SKIP_PIP_INSTALL=1

export PYTHONPATH="$( pwd ):$PYTHONPATH"
# so tired of pyroute2
#sphinx-build -b man doc/source doc/build/man
#sphinx-build -b html doc/source doc/build/html

PYTHONPATH=. tools/generate_config_file_samples.sh

%pyproject_build

%install

%pyproject_install
export PBR_VERSION=%version
#%python3_install --prefix=%_prefix --install-data=/


# Remove unused files
rm -rf %buildroot%python_sitelibdir/bin
rm -rf %buildroot%python_sitelibdir/doc
rm -rf %buildroot%python_sitelibdir/tools
rm -rf %buildroot%python3_sitelibdir/bin
rm -rf %buildroot%python3_sitelibdir/doc
rm -rf %buildroot%python3_sitelibdir/tools

rm -f %buildroot/etc/init.d/neutron-server

# Install logrotate
install -p -D -m 644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/%name

# Install sudoers
install -p -D -m 400 %SOURCE2 %buildroot%_sysconfdir/sudoers.d/neutron

# Install tmpfiles
install -p -D -m 644 %SOURCE3 %buildroot%_tmpfilesdir/%name.conf

# Install sysconfig
install -p -D -m 644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/neutron

# Install helper scripts
install -p -D -m 755 %SOURCE6 %buildroot%_bindir/neutron-enable-bridge-firewall.sh

# Install systemd units
install -p -D -m 644 %SOURCE10 %buildroot%_unitdir/neutron-server.service
install -p -D -m 644 %SOURCE11 %buildroot%_unitdir/neutron-linuxbridge-agent.service
install -p -D -m 644 %SOURCE12 %buildroot%_unitdir/neutron-openvswitch-agent.service
install -p -D -m 644 %SOURCE15 %buildroot%_unitdir/neutron-dhcp-agent.service
install -p -D -m 644 %SOURCE16 %buildroot%_unitdir/neutron-l3-agent.service
install -p -D -m 644 %SOURCE17 %buildroot%_unitdir/neutron-metadata-agent.service
install -p -D -m 644 %SOURCE18 %buildroot%_unitdir/neutron-ovs-cleanup.service
install -p -D -m 644 %SOURCE19 %buildroot%_unitdir/neutron-macvtap-agent.service
install -p -D -m 644 %SOURCE20 %buildroot%_unitdir/neutron-metering-agent.service
install -p -D -m 644 %SOURCE21 %buildroot%_unitdir/neutron-sriov-nic-agent.service
install -p -D -m 644 %SOURCE29 %buildroot%_unitdir/neutron-rpc-server.service

# Install sysV init scripts
install -p -D -m 755 %SOURCE110 %buildroot%_initdir/neutron-server
install -p -D -m 755 %SOURCE111 %buildroot%_initdir/neutron-linuxbridge-agent
install -p -D -m 755 %SOURCE112 %buildroot%_initdir/neutron-openvswitch-agent
install -p -D -m 755 %SOURCE115 %buildroot%_initdir/neutron-dhcp-agent
install -p -D -m 755 %SOURCE116 %buildroot%_initdir/neutron-l3-agent
install -p -D -m 755 %SOURCE117 %buildroot%_initdir/neutron-metadata-agent
install -p -D -m 755 %SOURCE118 %buildroot%_initdir/neutron-ovs-cleanup
install -p -D -m 755 %SOURCE119 %buildroot%_initdir/neutron-macvtap-agent
install -p -D -m 755 %SOURCE120 %buildroot%_initdir/neutron-metering-agent
install -p -D -m 755 %SOURCE121 %buildroot%_initdir/neutron-sriov-nic-agent
install -p -D -m 755 %SOURCE129 %buildroot%_initdir/neutron-rpc-server

# Setup directories
install -d -m 755 %buildroot%_sharedstatedir/neutron
install -d -m 755 %buildroot%_logdir/neutron
install -d -m 755 %buildroot%_runtimedir/neutron
install -d -m 750 %buildroot%_cachedir/neutron

# configuration files
for c in neutron.conf dhcp_agent.ini l3_agent.ini metadata_agent.ini metering_agent.ini ; do
    install -p -D -m 644 etc/$c.sample %buildroot%_sysconfdir/neutron/$c
done
for c in linuxbridge_agent.ini ml2_conf.ini openvswitch_agent.ini sriov_agent.ini macvtap_agent.ini ; do
    install -p -D -m 644 etc/neutron/plugins/ml2/$c.sample %buildroot%_sysconfdir/neutron/plugins/ml2/$c
done

### extra config dirs
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-server.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-l3-agent.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-dhcp-agent.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-metadata-agent.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-linuxbridge-agent.conf.d/
install -d -m 755 %buildroot%_sysconfdir/neutron/neutron-openvswitch-agent.conf.d/

cp -r neutron/locale %buildroot%python3_sitelibdir/neutron/locale
cp neutron/db/migration/alembic.ini %buildroot%python3_sitelibdir/neutron/db/migration/alembic.ini
cp neutron/db/migration/alembic_migrations/script.py.mako %buildroot%python3_sitelibdir/neutron/db/migration/alembic_migrations/script.py.mako
cp -r neutron/db/migration/alembic_migrations/versions %buildroot%python3_sitelibdir/neutron/db/migration/alembic_migrations/versions

## ALTLinux configuration defaults
%define neutron_conf %buildroot%_sysconfdir/neutron/neutron.conf.d/010-neutron.conf
%define plugin_dir %buildroot%_sysconfdir/neutron/plugins/
crudini --set %neutron_conf DEFAULT state_path /var/lib/neutron
crudini --set %neutron_conf DEFAULT log_dir /var/log/neutron
crudini --set %neutron_conf agent root_helper "sudo neutron-rootwrap /etc/neutron/rootwrap.conf"
crudini --set %neutron_conf oslo_concurrency lock_path /var/run/neutron

%pre
%_sbindir/groupadd -r -f neutron 2>/dev/null ||:
%_sbindir/useradd -r -g neutron -G neutron,wheel -c 'OpenStack Neutron Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/neutron neutron 2>/dev/null ||:

%post server
%post_service neutron-server
%preun server
%preun_service neutron-server

%post dhcp-agent
%post_service neutron-dhcp-agent
%preun dhcp-agent
%preun_service neutron-dhcp-agent

%post l3-agent
%post_service neutron-l3-agent
%preun l3-agent
%preun_service neutron-l3-agent

%post metadata-agent
%post_service neutron-metadata-agent
%preun metadata-agent
%preun_service neutron-metadata-agent


%post linuxbridge-agent
oldconf=%_sysconfdir/neutron/plugins/linuxbridge/linuxbridge_conf.ini
newconf=%_sysconfdir/neutron/plugins/ml2/linuxbridge_agent.ini
if [ $1 -gt 1 ]; then
    if [ -e $oldconf ]; then
        # Imitate noreplace
        cp $newconf ${newconf}.rpmnew
        cp $oldconf $newconf
    fi
fi
%post_service neutron-linuxbridge-agent

%preun linuxbridge-agent
%preun_service neutron-linuxbridge-agent

%post openvswitch-agent
oldconf=%_sysconfdir/neutron/plugins/openvswitch/ovs_neutron_plugin.ini
newconf=%_sysconfdir/neutron/plugins/ml2/openvswitch_agent.ini
if [ $1 -gt 1 ]; then
    if [ -e $oldconf ]; then
        # Imitate noreplace
        cp $newconf ${newconf}.rpmnew
        cp $oldconf $newconf
    fi
fi

%post_service neutron-openvswitch-agent
%post_service neutron-ovs-cleanup

%preun openvswitch-agent
%preun_service neutron-openvswitch-agent
%preun_service neutron-ovs-cleanup

%post metering-agent
%post_service neutron-metering-agent
%preun metering-agent
%preun_service neutron-metering-agent

%post sriov-nic-agent
%post_service neutron-sriov-nic-agent
%preun sriov-nic-agent
%preun_service neutron-sriov-nic-agent

%files
%doc LICENSE
%doc README.rst

%_bindir/neutron-enable-bridge-firewall.sh

%config(noreplace) %_sysconfdir/sysconfig/neutron
%dir %_sysconfdir/neutron
%dir %_sysconfdir/neutron/neutron.conf.d/
%dir %_sysconfdir/neutron/neutron-server.conf.d/
%dir %_sysconfdir/neutron/neutron-l3-agent.conf.d/
%dir %_sysconfdir/neutron/neutron-dhcp-agent.conf.d/
%dir %_sysconfdir/neutron/neutron-metadata-agent.conf.d/
%dir %_sysconfdir/neutron/neutron-linuxbridge-agent.conf.d/
%dir %_sysconfdir/neutron/neutron-openvswitch-agent.conf.d/
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/api-paste.ini
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/neutron.conf
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/neutron.conf.d/010-neutron.conf
%config(noreplace) %_sysconfdir/neutron/rootwrap.conf
%dir %_sysconfdir/neutron/plugins
%dir %_sysconfdir/neutron/plugins/ml2
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/plugins/ml2/*.ini
%config(noreplace) %_sysconfdir/logrotate.d/*
%config(noreplace) %_sysconfdir/sudoers.d/neutron
%dir %attr(0755, neutron, neutron) %_sharedstatedir/neutron
%dir %attr(0770, root, neutron) %_logdir/neutron
%dir %attr(0750, neutron, neutron) %_runtimedir/neutron
%dir %attr(0750, neutron, neutron) %_cachedir/neutron
%_tmpfilesdir/%name.conf
%dir %_sysconfdir/neutron/rootwrap.d
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/rootwrap.d/*.filters

%files -n python3-module-%oname
%doc LICENSE
%doc README.rst
%_bindir/*
%exclude %_bindir/neutron-enable-bridge-firewall.sh
%python3_sitelibdir/*
%_datadir/ansible/neutron-ovn-migration/playbooks
%exclude %python3_sitelibdir/%oname/tests

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%files server
%_unitdir/neutron-server.service
%_initdir/neutron-server
%_unitdir/neutron-rpc-server.service
%_initdir/neutron-rpc-server

%files dhcp-agent
%_initdir/neutron-dhcp-agent
%_unitdir/neutron-dhcp-agent.service
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/dhcp_agent.ini

%files l3-agent
%_unitdir/neutron-l3-agent.service
%_initdir/neutron-l3-agent
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/l3_agent.ini

%files metadata-agent
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/metadata_agent.ini
%_unitdir/neutron-metadata-agent.service
%_initdir/neutron-metadata-agent

%files linuxbridge-agent
%_unitdir/neutron-linuxbridge-agent.service
%_initdir/neutron-linuxbridge-agent

%files openvswitch-agent
%_unitdir/neutron-openvswitch-agent.service
%_initdir/neutron-openvswitch-agent
%_unitdir/neutron-ovs-cleanup.service
%_initdir/neutron-ovs-cleanup

%files macvtap-agent
%_unitdir/neutron-macvtap-agent.service
%_initdir/neutron-macvtap-agent

%files metering-agent
%_unitdir/neutron-metering-agent.service
%_initdir/neutron-metering-agent
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/metering_agent.ini

%files sriov-nic-agent
%_unitdir/neutron-sriov-nic-agent.service
%_initdir/neutron-sriov-nic-agent

%changelog
