%define oname neutron-lbaas

%def_without tests

Name: openstack-%oname
Epoch: 1
Version: 14.0.0
Release: alt2

Summary: OpenStack Networking LBaaS

Group: System/Servers
License: ASL 2.0
Url: http://docs.openstack.org/developer/%oname

Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
Source1: neutron-lbaasv2-agent.init
Source2: neutron-lbaasv2-agent.service

BuildArch: noarch

Requires: haproxy

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-six >= 1.10.0
BuildRequires: python3-module-eventlet >= 0.18.2
BuildRequires: python3-module-requests >= 2.14.2
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-neutron-lib >= 1.25.0
BuildRequires: python3-module-neutron >= 13.0.0
BuildRequires: python3-module-SQLAlchemy >= 1.0.10
BuildRequires: python3-module-alembic >= 0.8.10
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-oslo.db >= 4.37.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.log >= 3.36.0
BuildRequires: python3-module-oslo.messaging >= 5.29.0
BuildRequires: python3-module-oslo.reports >= 1.18.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.service >= 1.24.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-barbicanclient >= 4.5.2
BuildRequires: python3-module-pyasn1 >= 0.1.8
BuildRequires: python3-module-pyasn1-modules >= 0.0.6
BuildRequires: python3-module-pymysql >= 0.7.6
BuildRequires: python3-module-OpenSSL >= 17.1.0
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-cryptography >= 2.1
BuildRequires: python3-module-keystoneauth1 >= 3.4.0

%description
This package contains the code for the Neutron Load Balancer as a
Service (LBaaS) service. This includes third-party drivers. This package
requires Neutron to run.

%package -n python3-module-%oname
Summary: Neutron LBaaS Python3 libraries
Group: Development/Python3
Requires: python3-module-neutron >= 13.0.0
Requires: python3-module-neutron-lib >= 1.25.0
%add_python3_req_skip a10_neutron_lbaas
%add_python3_req_skip brocade_neutron_lbaas
%add_python3_req_skip heleosapi
%add_python3_req_skip kemptech_openstack_lbaas
%add_python3_req_skip f5lbaasdriver
%add_python3_req_skip f5lbaasdriver.v2.bigip.driver_v2

%description -n python3-module-%oname
This package contains the code for the Neutron Load Balancer as a
Service (LBaaS) service. This includes third-party drivers. This package
requires Neutron to run.

This package contains the neutron Python3 library.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%prep
%setup -n %oname-%version

%build
%python3_build
PYTHONPATH=. tools/generate_config_file_samples.sh

%install
%python3_install --install-data=/

# configuration files
install -p -D -m 644 etc/neutron_lbaas.conf.sample %buildroot%_sysconfdir/neutron/neutron_lbaas.conf
install -p -D -m 644 etc/lbaas_agent.ini.sample %buildroot%_sysconfdir/neutron/lbaas_agent.ini
install -p -D -m 644 etc/services_lbaas.conf.sample %buildroot%_sysconfdir/neutron/services_lbaas.conf

# Install sysV init scripts
install -p -D -m 755 %SOURCE1 %buildroot%_initdir/neutron-lbaasv2-agent

# Install systemd units
install -p -D -m 644 %SOURCE2 %buildroot%_unitdir/neutron-lbaasv2-agent.service

%post
%post_service neutron-lbaasv2-agent

%preun
%preun_service neutron-lbaasv2-agent

%files
%doc LICENSE
%doc README.rst
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/*.ini
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/*.conf
%config(noreplace) %attr(0640, root, neutron) %_sysconfdir/neutron/rootwrap.d/*.filters
%_initdir/neutron-lbaasv2-agent
%_unitdir/neutron-lbaasv2-agent.service

%files -n python3-module-%oname
%doc LICENSE
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
