%define oname placement
%define distinfoname openstack_placement

Name: openstack-%oname
Version: 9.0.0
Release: alt3.p10

%def_without docs
%def_with tests

Summary: OpenStack resource provider inventory allocation service

License: Apache-2.0
Group:   System/Servers
URL:     https://github.com/openstack/placement

Source1: %name.logrotate
Source2: %name-api.conf
Source3: %name-api.start
Source4: %oname.conf
Source5: policy.yaml

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildArch: noarch

Source:  %oname-%version.tar

Requires(pre): python3-module-placement = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-apache2
BuildRequires: python3-module-wheel
#BuildRequires: python3-module-tox
BuildRequires: python3-module-pbr >= 3.1.1
BuildRequires: python3-module-sqlalchemy >= 1.4.0
BuildRequires: python3-module-keystonemiddleware >= 4.18.0
BuildRequires: python3-module-routes >= 2.3.1
BuildRequires: python3-module-webob >= 1.8.2
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-requests >= 2.25.0
BuildRequires: python3-module-setuptools >= 21.0.0
BuildRequires: python3-module-oslo.concurrency >= 3.26.0
BuildRequires: python3-module-oslo.config >= 6.7.0
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.log >= 4.3.0
BuildRequires: python3-module-oslo.serialization >= 2.25.0
BuildRequires: python3-module-oslo.utils >= 4.5.0
BuildRequires: python3-module-oslo.db >= 8.6.0
BuildRequires: python3-module-oslo.policy >= 3.7.0
BuildRequires: python3-module-oslo.middleware >= 3.31.0
BuildRequires: python3-module-oslo.upgradecheck >= 1.3.0
BuildRequires: python3-module-os-resource-classes >= 1.1.0
BuildRequires: python3-module-os-traits >= 2.10.0
BuildRequires: python3-module-microversion-parse >= 0.2.1

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-sphinxcontrib-actdiag >= 0.8.5
BuildRequires: python3-module-sphinxcontrib-seqdiag >= 0.8.4
BuildRequires: python3-module-sphinx-feature-classification >= 0.2.0
BuildRequires: python3-module-os-api-ref >= 1.4.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-whereto >= 0.3.0
BuildRequires: python3-module-osprofiler >= 1.4.0
%endif

%if_with tests
BuildRequires: python3-module-hacking >= 4.0.0 python3-module-hacking < 4.1.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-psycopg2 >= 2.8
BuildRequires: python3-module-pymysql >= 0.8.0
BuildRequires: python3-module-oslotest >= 3.5.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-gabbi >= 1.35.0
BuildRequires: python3-module-cryptography >= 2.7
BuildRequires: python3-module-wsgi_intercept >= 1.7.0
BuildRequires: python3-module-osprofiler >= 1.4.0
%endif

%description
OpenStack Placement provides an HTTP service for managing, selecting,
and claiming providers of classes of inventory representing available resources
in a cloud.

%package -n python3-module-%oname
Summary: Placement Python libraries
Group: Development/Python3

Requires: apache2-base
Requires: python3-module-pbr >= 3.1.1
Requires: python3-module-sqlalchemy >= 1.4.0
Requires: python3-module-keystonemiddleware = 10.2.0
Requires: python3-module-routes >= 2.3.1
Requires: python3-module-webob >= 1.8.2
Requires: python3-module-jsonschema >= 3.2.0
Requires: python3-module-requests >= 2.25.0
Requires: python3-module-setuptools >= 21.0.0
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.context >= 5.1.0 python3-module-oslo.context <= 5.1.1
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.db >= 12.2.0 python3-module-oslo.db <= 12.3.2
Requires: python3-module-oslo.policy >= 4.1.0 python3-module-oslo.policy <= 4.1.1
Requires: python3-module-oslo.middleware >= 5.1.0 python3-module-oslo.middleware <= 5.1.1
Requires: python3-module-oslo.upgradecheck >= 2.1.0 python3-module-oslo.upgradecheck <= 2.1.1
Requires: python3-module-os-resource-classes >= 1.1.0
Requires: python3-module-os-traits >= 2.10.0
Requires: python3-module-microversion-parse >= 0.2.1

%description -n python3-module-%oname
OpenStack Placement provides an HTTP service for managing, selecting,
and claiming providers of classes of inventory representing available resources
in a cloud.

%if_with tests
%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3

Requires: python3-module-hacking >= 4.0.0 python3-module-hacking < 4.1.0
Requires: python3-module-coverage >= 4.0
Requires: python3-module-fixtures >= 3.0.0
Requires: python3-module-psycopg2 >= 2.8
Requires: python3-module-pymysql >= 0.8.0
Requires: python3-module-oslotest >= 3.5.0
Requires: python3-module-stestr >= 1.0.0
Requires: python3-module-testtools >= 2.2.0
Requires: python3-module-bandit >= 1.1.0
Requires: python3-module-gabbi >= 1.35.0
Requires: python3-module-cryptography >= 2.7
Requires: python3-module-wsgi_intercept >= 1.7.0
Requires: python3-module-osprofiler >= 1.4.0

%description -n python3-module-%oname-tests
This package contains tests for %oname.
%endif

%if_with docs
%package doc
Summary: Documentation for OpenStack Image Service
Group: Development/Documentation
Requires: %name = %EVR

%description doc
OpenStack Placement provides an HTTP service for managing, selecting,
and claiming providers of classes of inventory representing available resources
in a cloud.
%endif

%prep
%setup -n %oname-%version

%build
export PBR_VERSION=%version
%pyproject_build

#tox.py3 -e genconfig
#tox.py3 -e genpolicy

%if_with docs
rm -rf build/sphinx/html/.buildinfo
sphinx-build-3 -b man doc/source doc/build/man
%endif

%install
%pyproject_install

### configuration files
install -d -m 0750 %buildroot%_sysconfdir/%oname
install -d -m 0755 %buildroot%apache2_sites_available/
install -d -m 0755 %buildroot%apache2_sites_enabled/
install -d -m 0755 %buildroot%apache2_sites_start/
#cp -pr etc/* %buildroot%_sysconfdir/placement
install -m 0640 -D -p %SOURCE4 %buildroot%_sysconfdir/%oname/
install -m 0640 -D -p %SOURCE5 %buildroot%_sysconfdir/%oname/
install -m 0644 -D -p %SOURCE2 %buildroot%apache2_sites_available/
install -m 0644 -D -p %SOURCE3 %buildroot%apache2_sites_start/101-openstack-placement-api.conf
mkdir -p %buildroot%apache2_sites_enabled
touch %buildroot%apache2_sites_enabled/%name-api.conf

install -d -m 750 %buildroot%_sharedstatedir/placement

cp -r placement/db/sqlalchemy/alembic/ %buildroot%python3_sitelibdir/placement/db/sqlalchemy/alembic/
cp placement/db/sqlalchemy/alembic.ini %buildroot%python3_sitelibdir/placement/db/sqlalchemy/alembic.ini

# Install log directory
install -d -m 770 %buildroot%_logdir/placement

# Logrotate config
install -p -D -m 644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/openstack-placement

%if_with docs
install -d %buildroot%_mandir/man1
install -m 644 doc/build/man/*.1 %buildroot%_mandir/man1
%endif

# cleanup
#rm -rf %buildroot/usr/etc

%pre
# 163:163 for keystone (openstack-keystone)
%_sbindir/groupadd -r -g 164 -f placement 2>/dev/null ||:
%_sbindir/useradd -r -u 164 -g placement -c 'OpenStack Placement Daemons' \
        -s /sbin/nologin  -d %_sharedstatedir/placement placement 2>/dev/null ||:

%files
%doc README.rst
%doc placement_db_tools/*
%config(noreplace) %apache2_sites_available/*.conf
%apache2_sites_start/*.conf
%ghost %apache2_sites_enabled/*.conf
%dir %attr(0750, root, placement) %_sysconfdir/placement
%config(noreplace) %attr(0640, root, placement) %_sysconfdir/placement/placement.conf
%config %attr(0640, root, placement) %_sysconfdir/placement/policy.yaml
%config(noreplace) %_sysconfdir/logrotate.d/openstack-placement
%dir %attr(0750, placement, placement) %_sharedstatedir/placement
%dir %attr(0750, placement, placement) %_logdir/placement

%files -n python3-module-%oname
%_bindir/*
%python3_sitelibdir/%oname/
%python3_sitelibdir/placement_db_tools/
%python3_sitelibdir/%distinfoname-%version.dist-info/
%exclude %python3_sitelibdir/%oname/tests

%if_with tests
%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%if_with docs
%files doc
%doc README.rst
%doc doc/build/html
%endif

%changelog
