%define _unpackaged_files_terminate_build 1

%ifarch %mips32
%define optflags_debug -g1
%endif

%define soname 8.1

Name: openvdb
Version: 8.1.0
Release: alt1
Summary: C++ library for sparse volumetric data discretized on three-dimensional grids
Group: Graphics
License: MPL-2.0-no-copyleft-exception
URL: https://www.openvdb.org

# https://github.com/AcademySoftwareFoundation/openvdb
Source: %name-%version.tar

Patch1: openvdb-8.0.0-alt-link-with-libatomic-on-mips.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: boost-complete
BuildRequires: cmake
BuildRequires: doxygen
BuildRequires: gcc-c++
BuildRequires: ghostscript
BuildRequires: pkgconfig(blosc) >= 1.5.0
BuildRequires: pkgconfig(cppunit) >= 1.10
BuildRequires: pkgconfig(glfw3) >= 2.7
BuildRequires: ilmbase-devel
BuildRequires: pkgconfig(jemalloc)
BuildRequires: pkgconfig(log4cplus) >= 1.0
BuildRequires: pkgconfig(tbb) >= 3.0
BuildRequires: pkgconfig(xi)
BuildRequires: pkgconfig(zlib) > 1.2.7
BuildRequires: pkgconfig(python3)
BuildRequires: python3-module-numpy libnumpy-py3-devel

%description
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

This package contains some graphical tools.

%package -n lib%name%soname
Summary: Core OpenVDB libraries
Group: System/Libraries

%description -n lib%name%soname
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

%package devel
Summary: Development files for %{name}
Group: Development/C++
Requires: lib%name%soname = %EVR

%description devel
The %{name}-devel package contains libraries and header files for developing
applications that use %{name}.

%package -n python3-module-%name
Summary: OpenVDB Python module
Group: Development/Python3
Requires: lib%name%soname = %EVR

%description -n python3-module-%name
OpenVDB is an Academy Award-winning open-source C++ library comprising a novel
hierarchical data structure and a suite of tools for the efficient storage and
manipulation of sparse volumetric data discretized on three-dimensional grids.
It is developed and maintained by Academy Software Foundation for use in
volumetric applications typically encountered in feature film production.

This package contains the Python module.

%prep
%setup
%autopatch -p1

# Hardcoded values
sed -i \
	-e 's|lib$|%_lib|g' \
	%name/%name/CMakeLists.txt %name/%name/python/CMakeLists.txt

%build
%cmake \
	-DOPENVDB_BUILD_DOCS=ON \
	-DOPENVDB_CORE_SHARED=ON \
	-DOPENVDB_CORE_STATIC=OFF \
	-DOPENVDB_ENABLE_RPATH=OFF \
	-DOPENVDB_ENABLE_UNINSTALL:BOOL=OFF \
	-DUSE_IMATH_HALF=ON \
	-DUSE_LOG4CPLUS=ON \
	-DOPENVDB_BUILD_PYTHON_MODULE=ON \
	-DUSE_NUMPY:BOOL=ON \
	-DPYOPENVDB_INSTALL_DIRECTORY=%python3_sitelibdir \
	-DPython_EXECUTABLE=%_bindir/python3 \
	%nil

%cmake_build

%install
%cmakeinstall_std

%files
%_bindir/vdb_print

%files -n lib%name%soname
%doc %name/%name/LICENSE %name/%name/COPYRIGHT
%doc README.md CHANGES
%_libdir/lib%{name}.so.%{soname}
%_libdir/lib%{name}.so.%{soname}.*

%files -n python3-module-%name
%python3_sitelibdir/py%{name}.so

%files devel
%_defaultdocdir/OpenVDB
%_includedir/*
%_libdir/lib%{name}.so
%_libdir/cmake/*

%changelog
