%def_disable snapshot
%define ver_major 0.4
%def_enable gtk_doc

%ifarch ppc64le
%def_disable check
%else
%def_enable check
%endif

%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: orc
Version: %ver_major.40
Release: alt1

Summary: The Oil Runtime Compiler
Group: Development/Other
License: BSD-3-Clause
Url: http://code.entropywave.com/projects/orc

%if_disabled snapshot
#Source: https://github.com/GStreamer/orc/archive/%version/%name-%version.tar.gz
Source: https://gstreamer.freedesktop.org/src/%name/%name-%version.tar.xz
%else
Vcs: https://anongit.freedesktop.org/gstreamer/orc.git
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-meson rpm-macros-valgrind
BuildRequires: meson >= 0.54 glib2-devel >= 2.10.0 gtk-doc
%{?_enable_valgrind:BuildRequires: valgrind-devel}

%description
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

%package -n lib%name
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc library.

%package -n lib%name-devel
Summary: Development files for liborc
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc library.

%package -n lib%name-test
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name-test
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc test library.

%package -n lib%name-test-devel
Summary: Development test files for liborc
Group: Development/C
Requires: lib%name-test = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-test-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc test library.

%package doc
Summary: Dcumentation for Orc
Group: Development/Documentation
BuildArch: noarch

%description doc
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains documentation for Orc.

%prep
%setup

%build
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=enabled}
%nil
%meson_build

%install
%meson_install
rm -f %buildroot/%_libdir/lib%name-test-%ver_major.a

%check
%__meson_test

%files
%_bindir/%name-bugreport
%_bindir/%{name}c

%files -n lib%name
%_libdir/lib%name-%ver_major.so.*

%files -n lib%name-test
%_libdir/lib%name-test-%ver_major.so.*

%files -n lib%name-devel
%dir %_includedir/%name-%ver_major
%_includedir/%name-%ver_major/orc
%_libdir/lib%name-%ver_major.so
%_pkgconfigdir/%name-%ver_major.pc

%files -n lib%name-test-devel
%_includedir/%name-%ver_major/%name-test
%_libdir/lib%name-test-%ver_major.so
%_pkgconfigdir/%name-test-%ver_major.pc

%files doc
%_datadir/gtk-doc/html/%name

%changelog
