Name: parole
Version: 4.18.2
Release: alt1

%def_enable clutter
%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

Summary: Media player for the Xfce desktop
License: GPLv2+
Group: Video

URL: https://docs.xfce.org/apps/parole/start
Vcs: https://gitlab.xfce.org/apps/parole.git
Source: %name-%version.tar
Source1: alt_ru.po
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

BuildRequires(pre): rpm-build-xfce4 >= 0.3.0 xfce4-dev-tools
BuildRequires: libxfce4ui-gtk3-devel libxfce4util-devel libxfconf-devel
BuildRequires: libgtk+3-devel libnotify-devel libtag-devel
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel
BuildRequires: libdbus-glib-devel libdbus-devel
%{?_enable_clutter:BuildRequires: libclutter-devel libclutter-gtk3-devel}
BuildRequires: gtk-doc

Requires: gstreamer1.0
Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-plugins-ugly1.0 gst-libav

%define _unpackaged_files_terminate_build 1

%description
Parole is a modern simple media player based on the GStreamer framework
and written to fit well in the Xfce desktop. Parole features playback of
local media files, DVD/CD and live streams. Parole is extensible via
plugins.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: libgtk+3-devel
BuildArch: noarch

%description devel
This package contains header files and documentation
for developing plugins for %name.

%prep
%setup
%patch -p1

# Merge our own and upstream Russian translations
msgcat --use-first -o merged_ru.po %SOURCE1 po/ru.po
mv -f merged_ru.po po/ru.po

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-x11 \
	%{subst_enable wayland} \
	--enable-taglib \
	%{subst_enable clutter} \
	--enable-gtk-doc \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS README.md THANKS NEWS
%_bindir/%name
%_libdir/%name-*/
%exclude %_libdir/%name-*/*.la
%_desktopdir/*.desktop
%_datadir/metainfo/%name.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/%name/

%files devel
%_includedir/*
%doc %_datadir/gtk-doc/html/*

%changelog
