Name: patchage
Version: 1.0.4
Release: alt1

Summary: A modular patch bay for JACK and LASH audio systems
License: %gpl2plus
Group: Sound
Url: https://drobilla.net/software/patchage

Source0: %name-%version.tar
Source1: waf.tar
Patch1: patchage-1.0.4-fix-compilation.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-python3
BuildRequires: doxygen graphviz libganv-devel
BuildRequires: gcc-c++ libflowcanvas-devel boost-devel
BuildRequires: libglademm-devel libalsa-devel libjack-devel
BuildRequires: desktop-file-utils libdbus-devel libdbus-glib-devel

%description
Patchage is a modular patch bay for audio and MIDI systems based on
Jack, Lash, and Alsa.

%prep
%setup
%patch1 -p1
tar xf %SOURCE1
# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)

%build
./waf configure \
	--prefix=%prefix \
	--configdir=%_sysconfdir \
	--libdir=%_libdir \
	--jack-dbus \
	--docs \
	--debug
./waf build -j %__nprocs

%install
./waf install --destdir=%buildroot

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=Midi \
	%buildroot%_desktopdir/patchage.desktop

%files -f %name.lang
%doc AUTHORS NEWS README.md
%_bindir/*
%_desktopdir/*
%_liconsdir/*
%_niconsdir/*
%_miconsdir/*
%_iconsdir/hicolor/*/apps/*.*
%_datadir/%name/*
%_man1dir/%name.1*

%changelog
