%define gtkver 2

Name: pcmanfm
Version: 1.3.2
Release: alt1

Summary: PCMan File Manager
License: GPL-2.0-or-later
Group: Graphical desktop/Other

Url: https://github.com/lxde/pcmanfm
Source: %name-%version.tar

Provides: pcmanfm2 = %version-%release
Obsoletes: pcmanfm2 < 1.2.0

BuildRequires: rpm-build-xdg
BuildRequires: libgtk+%gtkver-devel >= 2.18.0
BuildRequires: libfm-devel >= 1.2.0
BuildRequires: libgio-devel

BuildRequires: libdbus-glib-devel libstartup-notification-devel libgamin-devel intltool libmenu-cache-devel menu-cache

# See bug 34867
Requires: menu-cache lxde-freedesktop-menu

%description
Features:
    * Extremly fast and lightweight
    * Can be started in under a second on reasonable hardware
    * Tabbed browsing (similar to Firefox)
    * Drag&Drop support
    * Files can be dragged among tabs
    * Loads large directories in reasonable time
    * File association support (default applications)
    * Basic thumbnail support
    * Bookmarks support
    * Handles non-UTF-8 encoded filenames correctly
    * Provides icon view and detailed list view
    * Standards compliant (follows freedesktop.org)
    * Clean and user-friendly interface (GTK+%gtkver)

%package devel
Summary: Development files for %name
Group: Development/Other
Buildarch: noarch

%description devel
This package contains header files.

%prep
%setup

%build
%autoreconf
%configure \
    --enable-largefile \
    --with-gtk=%gtkver
%make_build

%install
%makeinstall_std
%find_lang %name
ln -s %name %buildroot%_bindir/pcmanfm2

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/%name
%_xdgconfigdir/%name
%_man1dir/*

%files devel
%_includedir/*

%changelog
