%define _localstatedir %_var

Name: pdns-recursor
Version: 4.9.2
Release: alt1
Summary: Modern, advanced and high performance recursing/non authoritative name server
License: GPL-2.0
Group: System/Servers
URL: https://powerdns.com
Source0: https://downloads.powerdns.com/releases/%name-%version.tar.bz2
Source1: %name.watch

ExcludeArch: %arm %ix86

Provides: powerdns-recursor = %version-%release
BuildRequires: boost-complete
BuildRequires: gcc-c++
%ifarch %arm %ix86 x86_64 %mips aarch64
BuildRequires: libluajit-devel
%else
BuildRequires: lua-devel
%endif
%ifarch ppc64 ppc64le
BuildRequires: libatomic1
%endif
BuildRequires: libcap-devel
BuildRequires: libcurl-devel
BuildRequires: libfstrm-devel
BuildRequires: libprotobuf-devel
BuildRequires: libsodium-devel
BuildRequires: libssl-devel
BuildRequires: libsystemd-devel
BuildRequires: libudev-devel
BuildRequires: libudev-devel
BuildRequires: systemd-analyze
BuildRequires: systemd-homed
BuildRequires: systemd-networkd
BuildRequires: systemd-portable
BuildRequires: systemd-sysvinit

%description
PowerDNS Recursor is a non authoritative/recursing DNS server. Use this
package if you need a dns cache for your network.

%prep
%setup

%build
%configure \
    --sysconfdir=%_sysconfdir/%name \
    --with-libsodium \
    --enable-reproducible \
    --enable-dnstap \
    --enable-dns-over-tls \
%ifarch %arm %ix86 x86_64 %mips aarch64
    --with-lua=luajit \
%else
    --with-lua \
%endif
    --with-socketdir=%_runtimedir

%make_build


%install
%makeinstall_std

mv %buildroot%_sysconfdir/%name/recursor.conf{-dist,}

# add directories for newly-observed-domains/unique-domain-response
install -p -d -m 0755 %buildroot/%_sharedstatedir/%name/nod
install -p -d -m 0755 %buildroot/%_sharedstatedir/%name/udr

# change user and group to pdns-recursor
sed -i \
    -e 's/# setuid=/setuid=pdns-recursor/' \
    -e 's/# setgid=/setgid=pdns-recursor/' \
    -e 's/# security-poll-suffix=secpoll\.powerdns\.com\./security-poll-suffix=/' \
    %buildroot%_sysconfdir/%name/recursor.conf

# move systemd files
mkdir -p %buildroot/lib/systemd
mv %buildroot/usr/lib/systemd/* %buildroot%_unitdir

%pre
getent group pdns-recursor > /dev/null || groupadd -r pdns-recursor
getent passwd pdns-recursor > /dev/null || \
    useradd -r -g pdns-recursor -d / -s /sbin/nologin \
    -c "PowerDNS Recursor user" pdns-recursor
exit 0

%post
%post_service pdns-recursor

%preun
%preun_service pdns-recursor

%files
%doc README
%config(noreplace) %_sysconfdir/%name/recursor.conf
%_bindir/rec_control
%_sbindir/pdns_recursor
%_man1dir/pdns_recursor.1*
%_man1dir/rec_control.1*
%_unitdir/pdns-recursor.service
%_unitdir/pdns-recursor@.service
%dir %_sysconfdir/%name
%dir %attr(0755,pdns-recursor,pdns-recursor) %_sharedstatedir/%name
%dir %attr(0755,pdns-recursor,pdns-recursor) %_sharedstatedir/%name/nod
%dir %attr(0755,pdns-recursor,pdns-recursor) %_sharedstatedir/%name/udr

%changelog
