Epoch: 2
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-fedora-compat
BuildRequires: perl(AnyEvent/AIO.pm) perl(AnyEvent/BDB.pm) perl(BDB.pm) perl(IO/AIO.pm) perl(LWP/Simple.pm) perl(Net/Config.pm) perl(Net/FTP.pm) perl(Net/HTTP.pm) perl(Net/NNTP.pm) perl(Term/ReadLine.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global cpan_version 6.57
Name:           perl-Coro
Version:        6.570
Release:        alt4_1
Summary:        The only real threads in perl
# Coro/libcoro:    GPLv2 or BSD
# Rest of package: GPL+ or Artistic
License:        (GPL+ or Artistic) and (GPLv2 or BSD)
URL:            https://metacpan.org/release/Coro
Source0:        https://cpan.metacpan.org/authors/id/M/ML/MLEHMANN/Coro-%{cpan_version}.tar.gz
Patch0:         %{name}-5.25-ucontext-default.patch
# Do not disable hardening
Patch1:         Coro-6.512-Disable-disabling-FORTIFY_SOURCE.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  libecb-static
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Canary/Stability.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(EV.pm)
BuildRequires:  perl(EV/MakeMaker.pm)
BuildRequires:  perl(Event.pm)
BuildRequires:  perl(Event/MakeMaker.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(AnyEvent.pm)
# AnyEvent::AIO >= 1 not used at tests
# AnyEvent::BDB >= 1 not used at tests
# AnyEvent::DNS not used at tests
BuildRequires:  perl(AnyEvent/Socket.pm)
BuildRequires:  perl(AnyEvent/Util.pm)
BuildRequires:  perl(base.pm)
# BDB not used at tests
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(common/sense.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Guard.pm)
# IO::AIO >= 3.1 not used at tests
BuildRequires:  perl(IO/Socket/INET.pm)
# Net::Config not used at tests
# Net::FTP not used at tests
# Net::HTTP not used at tests
# Net::NNTP not used at tests
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Export correct required versions
Requires:       perl(AnyEvent.pm) >= 7
Requires:       perl(AnyEvent/AIO.pm) >= 1
Requires:       perl(AnyEvent/BDB.pm) >= 1
Requires:       perl(EV.pm) >= 4
Requires:       perl(Event.pm) >= 1.080
Requires:       perl(Guard.pm) >= 0.500
Requires:       perl(Storable.pm) >= 2.150
Requires:       perl(warnings.pm)



# Filter underspecified dependencies









Source44: import.info
Patch33: Coro-6.57-perl7.patch
%filter_from_requires /:__requires_exclude\|}^perl(AnyEvent.pm)/d
%filter_from_requires /^perl(AnyEvent\\) >= 4.800001$/d
%filter_from_requires /^perl(AnyEvent.AIO.pm)/d
%filter_from_requires /^perl(AnyEvent.BDB.pm)/d
%filter_from_requires /^perl(EV.pm)/d
%filter_from_requires /^perl(Event.pm)/d
%filter_from_requires /^perl(Guard.pm)/d
%filter_from_requires /^perl(Storable.pm)/d
%filter_from_provides /:__provides_exclude\|}^perl(Coro.pm)/d


%description
This module collection manages continuations in general, most often in the
form of cooperative threads (also called coros, or simply "coro" in the
documentation). They are similar to kernel threads but don't (in general) run
in parallel at the same time even on SMP machines. The specific flavor of
thread offered by this module also guarantees you that it will not switch
between threads unless necessary, at easily-identified points in your
program, so locking and parallel access are rarely an issue, making thread
programming much safer and easier than using other thread models.


%prep
%setup -q -n Coro-%{cpan_version}

%ifnarch %{ix86} x86_64 %{arm}
# use ucontext backend on non-x86 (setjmp didn't work on s390(x))
%patch0 -p1 -b .ucontext-default
%endif
%patch1 -p1

# Unbundle libecb
rm Coro/ecb.h
perl -i -lne 'print $_ unless m{\ACoro/ecb\.h\z}' MANIFEST
perl -i -pe 's/ecb\.h//' Coro/Makefile.PL

# Correct shebangs
for F in Coro/jit-*.pl; do
    perl -i -ne 'print $_ unless m{\A#!}' "$F"
    chmod -x "$F"
done
%fix_shbang_line eg/myhttpd

# no need; fixed by rebuild of perl-common-sense
#patch33 -p1

%build
# Disable FORTIFY_SOURCE on ARM as it breaks setjmp - RHBZ 750805
%ifarch %{arm}
RPM_OPT_FLAGS="${RPM_OPT_FLAGS} -Wp,-U_FORTIFY_SOURCE -Wp,-D_FORTIFY_SOURCE=0"
%endif

# Interactive configuration. Use default values.
perl Makefile.PL INSTALLDIRS=perl NO_PACKLIST=1 NO_PERLLOCAL=1 \
    OPTIMIZE="$RPM_OPT_FLAGS" </dev/null
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
%if 1
%{make_build} test
%endif

%files
%doc --no-dereference COPYING
%doc Changes README README.linux-glibc
%doc doc/* eg
%{perl_vendor_archlib}/auto/Coro
%{perl_vendor_archlib}/Coro
%{perl_vendor_archlib}/Coro.pm

%changelog
