%define _unpackaged_files_terminate_build 1
%define module_name Sereal
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Sereal/Decoder.pm) perl(Sereal/Encoder.pm) perl(Test/More.pm) perl(Test/Deep/NoTest.pm) perl(Test/LongString.pm) perl(Test/Warn.pm)
# END SourceDeps(oneline)
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.018
Release: alt1
Summary: Fast, compact, powerful binary (de-)serialization
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://www.cpan.org/authors/id/Y/YV/YVES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*Sereal* is an efficient, compact-output, binary and feature-rich
serialization protocol. The Perl encoder is implemented as the
the Sereal::Encoder manpage module, the Perl decoder correspondingly as 
the Sereal::Decoder manpage. They are distributed separately to allow for
safe upgrading without downtime. (Hint: Upgrade the decoder everywhere
first, then the encoder.)

This `Sereal' module is a very thin wrapper around both `Sereal::Encoder'
and `Sereal::Decoder'. It depends on both and loads both. So if you have
a user of both encoder and decoder, it is enough to depend on a particular
version of `Sereal' and you'll get the most recent released versions
of `Sereal::Encoder' and `Sereal::Decoder' whose version is smaller than
or equal to the version of `Sereal' you depend on.

The protocol specification and many other bits of documentation
can be found in the github repository. Right now, the specification is at
https://github.com/Sereal/Sereal/blob/master/sereal_spec.pod,
there is a discussion of the design objectives in
https://github.com/Sereal/Sereal/blob/master/README.pod, and the output
of our benchmarks can be seen at
https://github.com/Sereal/Sereal/wiki/Sereal-Comparison-Graphs.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
