Name: phpMyAdmin
Version: 5.2.1
Release: alt1

Summary: phpMyAdmin - web-based MySQL administration

License: GPLv2
Group: System/Servers
Url: http://www.phpmyadmin.net

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source: http://prdownloads.sourceforge.net/phpmyadmin/%name-%version-all-languages.tar
Source: https://files.phpmyadmin.net/phpMyAdmin/%version/phpMyAdmin-%version-all-languages.tar
Source3: %name.htaccess
Source6: %name.A.conf
Source8: %name-apache2.control

Provides: phpmyadmin
Obsoletes: %name-common

BuildArch: noarch

Requires: pwgen webserver-common control
Requires: apache2-base >= 2.4

BuildRequires(pre): rpm-build-apache2 rpm-macros-webserver-common
BuildRequires(pre): rpm-macros-features >= 0.8

BuildRequires: apache2-base >= 2.4
BuildRequires: control

AutoReq:yes,noshell,nomingw32,nopython

%if_feature php7 7.4.3
%def_with php7
%define defphp php7
%endif

%if_feature php82 8.2.0
%def_with php82
%define defphp php8.2
%endif

%if_feature php81 8.1.0
%def_with php81
%define defphp php8.1
%endif

%if_feature php80 8.0.0
%def_with php80
%define defphp php8.0
%endif



%description
phpMyAdmin can administer a whole MySQL-server (needs a super-user)
but also a single database. To accomplish the latter you'll need a
properly set up MySQL-user who can read/write only the desired
database. It's up to you to look up the appropiate part in the MySQL
manual. Currently phpMyAdmin can:
  - create and drop databases
  - create, copy, drop and alter tables
  - delete, edit and add fields
  - execute any SQL-statement, even batch-queries
  - manage keys on fields
  - load text files into tables
  - create (*) and read dumps of tables
  - export (*) and import data to CSV values
  - administer multiple servers and single databases
  - communicate in more than 20 different languages


%package apache2-php7
Summary: phpMyAdmin - web-based MySQL administration (for apache 2.4 and php7)
Group: System/Servers
Requires: %name = %EVR
Requires: apache2-mod_php7 >= 7.1.3
Requires: apache2-base

# from composer.json
Requires: php7-mysqlnd-mysqli
Requires: php7-openssl
Requires: php7-curl
Requires: php7-opcache
#Requires: php7-zlib
Requires: php7-bz2
Requires: php7-zip
Requires: php7-gd2
Requires: php7-mbstring
Requires: php7-mcrypt

Conflicts: %name-apache2

%description apache2-php7
phpMyAdmin can administer a whole MySQL-server (needs a super-user)
but also a single database. To accomplish the latter you'll need a
properly set up MySQL-user who can read/write only the desired
database. It's up to you to look up the appropiate part in the MySQL
manual. Currently phpMyAdmin can:
  - create and drop databases
  - create, copy, drop and alter tables
  - delete, edit and add fields
  - execute any SQL-statement, even batch-queries
  - manage keys on fields
  - load text files into tables
  - create (*) and read dumps of tables
  - export (*) and import data to CSV values
  - administer multiple servers and single databases
  - communicate in more than 20 different languages

Install this package if you need phpMyAdmin for apache 2.4 and php7.


%package apache2-php8.0
Summary: phpMyAdmin - web-based MySQL administration (for apache 2.4 and php8.0)
Group: System/Servers
Requires: %name = %EVR
Requires: apache2-mod_php8.0
Requires: apache2-base

# from composer.json
Requires: php8.0-mysqlnd-mysqli
Requires: php8.0-openssl
Requires: php8.0-curl
Requires: php8.0-opcache
#Requires: php7-zlib
Requires: php8.0-bz2
Requires: php8.0-zip
Requires: php8.0-gd2
Requires: php8.0-mbstring
Requires: php8.0-mcrypt

Conflicts: %name-apache2
Conflicts: %name-apache2-php7

%description apache2-php8.0
phpMyAdmin can administer a whole MySQL-server (needs a super-user)
but also a single database. To accomplish the latter you'll need a
properly set up MySQL-user who can read/write only the desired
database. It's up to you to look up the appropiate part in the MySQL
manual. Currently phpMyAdmin can:
  - create and drop databases
  - create, copy, drop and alter tables
  - delete, edit and add fields
  - execute any SQL-statement, even batch-queries
  - manage keys on fields
  - load text files into tables
  - create (*) and read dumps of tables
  - export (*) and import data to CSV values
  - administer multiple servers and single databases
  - communicate in more than 20 different languages

Install this package if you need phpMyAdmin for apache 2.4 and php8.0.


%package apache2-php8.1
Summary: phpMyAdmin - web-based MySQL administration (for apache 2.4 and php8.1)
Group: System/Servers
Requires: %name = %EVR
Requires: apache2-mod_php8.1
Requires: apache2-base

# from composer.json
Requires: php8.1-mysqlnd-mysqli
Requires: php8.1-openssl
Requires: php8.1-curl
Requires: php8.1-opcache
#Requires: php7-zlib
Requires: php8.1-bz2
Requires: php8.1-zip
Requires: php8.1-gd2
Requires: php8.1-mbstring
Requires: php8.1-mcrypt

Conflicts: %name-apache2
Conflicts: %name-apache2-php7

%description apache2-php8.1
phpMyAdmin can administer a whole MySQL-server (needs a super-user)
but also a single database. To accomplish the latter you'll need a
properly set up MySQL-user who can read/write only the desired
database. It's up to you to look up the appropiate part in the MySQL
manual. Currently phpMyAdmin can:
  - create and drop databases
  - create, copy, drop and alter tables
  - delete, edit and add fields
  - execute any SQL-statement, even batch-queries
  - manage keys on fields
  - load text files into tables
  - create (*) and read dumps of tables
  - export (*) and import data to CSV values
  - administer multiple servers and single databases
  - communicate in more than 20 different languages

Install this package if you need phpMyAdmin for apache 2.4 and php8.1.



%package apache2-php8.2
Summary: phpMyAdmin - web-based MySQL administration (for apache 2.4 and php8.2)
Group: System/Servers
Requires: %name = %EVR
Requires: apache2-mod_php8.2
Requires: apache2-base

# from composer.json
Requires: php8.2-mysqlnd-mysqli
Requires: php8.2-openssl
Requires: php8.2-curl
Requires: php8.2-opcache
#Requires: php7-zlib
Requires: php8.2-bz2
Requires: php8.2-zip
Requires: php8.2-gd2
Requires: php8.2-mbstring
Requires: php8.2-mcrypt

Conflicts: %name-apache2
Conflicts: %name-apache2-php7

%description apache2-php8.2
phpMyAdmin can administer a whole MySQL-server (needs a super-user)
but also a single database. To accomplish the latter you'll need a
properly set up MySQL-user who can read/write only the desired
database. It's up to you to look up the appropiate part in the MySQL
manual. Currently phpMyAdmin can:
  - create and drop databases
  - create, copy, drop and alter tables
  - delete, edit and add fields
  - execute any SQL-statement, even batch-queries
  - manage keys on fields
  - load text files into tables
  - create (*) and read dumps of tables
  - export (*) and import data to CSV values
  - administer multiple servers and single databases
  - communicate in more than 20 different languages

Install this package if you need phpMyAdmin for apache 2.4 and php8.2.

%prep
%setup

%install
mkdir -p %buildroot%webserver_webappsdir

cp config.sample.inc.php config.inc.php
# see https://bugzilla.altlinux.org/show_bug.cgi?id=37954
echo "\$cfg['TempDir'] = '/tmp';" >> config.inc.php

cp -r ../%name-%version %buildroot%webserver_webappsdir/%name

# remove unneeded
rm -rf %buildroot%webserver_webappsdir/%name/test/
rm -rf %buildroot%webserver_webappsdir/%name/doc/{_ext,doctrees,Makefile,make.bat,conf.py,*.rst}
rm -f %buildroot%webserver_webappsdir/%name/{.coveralls.yml,.editorconfig,.eslintignore,.eslintrc.json}

cp -a %SOURCE3 %buildroot%webserver_webappsdir/%name/.htaccess

%__mkdir_p %buildroot%apache2_extra_available
%__mkdir_p %buildroot%apache2_extra_enabled
cp %SOURCE6 %buildroot%apache2_extra_available/%name.conf
%__subst 's|--dir--|%webserver_webappsdir/%name|g' %buildroot%apache2_extra_available/%name.conf
ln -s %apache2_extra_available/%name.conf %buildroot%apache2_extra_enabled/%name.conf

#make control modules
#__mkdir_p %buildroot%_controldir
#cp %SOURCE8 %buildroot%_controldir/%name-apache2
#__subst 's|--dir--|%apache2_extra_available|g' %buildroot%_controldir/%name-apache2

%post
if grep -q "blowfish_secret'\] = ''" %webserver_webappsdir/%name/config.inc.php ; then
    echo "Generating new blowfish secret to %webserver_webappsdir/%name/config.inc.php"
    %__subst "s|\(blowfish_secret'\] = \)''|\1'$(pwgen -0s1 32)'|" %webserver_webappsdir/%name/config.inc.php
fi
#pre apache2
#pre_control %name-apache2

#post apache2
#post_control -s restricted %name-apache2

%files
%doc README* ChangeLog
%dir %webserver_webappsdir/%name/
%webserver_webappsdir/%name/*
%webserver_webappsdir/%name/.rtlcssrc.json
%config(noreplace) %webserver_webappsdir/%name/.htaccess
# yes, will notify about duplicate file
%attr(640,root,%webserver_group) %config(noreplace) %webserver_webappsdir/%name/config.inc.php
%exclude %webserver_webappsdir/%name/setup

%if_with php7
%files apache2-php7
%config(noreplace) %apache2_extra_available/%name.conf
%apache2_extra_enabled/%name.conf
#attr(755,root,root) %_controldir/%name-apache2
%endif

%if_with php80
%files apache2-php8.0
%config(noreplace) %apache2_extra_available/%name.conf
%apache2_extra_enabled/%name.conf
#attr(755,root,root) %_controldir/%name-apache2
%endif

%if_with php81
%files apache2-php8.1
%config(noreplace) %apache2_extra_available/%name.conf
%apache2_extra_enabled/%name.conf
#attr(755,root,root) %_controldir/%name-apache2
%endif

%if_with php82
%files apache2-php8.2
%config(noreplace) %apache2_extra_available/%name.conf
%apache2_extra_enabled/%name.conf
#attr(755,root,root) %_controldir/%name-apache2
%endif

%changelog
