%define rname plasma-desktop
%def_disable scim

Name: plasma5-desktop
Version: 5.27.11
Release: alt3
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 plasma desktop view furniture
Url: http://www.kde.org
License: GPL-2.0-or-later

Requires: plasma5-workspace
Requires: polkit-kde-plasma-desktop
# for ibus-ui-emojier-plasma
Requires: ibus-dicts

Source: %rname-%version.tar
Source10: kcm_multicomponentchooser-ru-add.po
Source11: kcm_touchpad-ru-add.po
Source1: multicomponentchooser.tar
Patch1: alt-def-color-scheme.patch
Patch2: alt-menu-icon.patch
Patch3: alt-def-apps-menu.patch
Patch4: alt-def-kicker.patch
Patch5: alt-multimedia-player-chooser.patch
Patch6: alt-def-panel.patch
Patch7: alt-def-desktop-containment.patch
Patch8: alt-def-desktop-widgets.patch
Patch9: alt-dont-indicate-audio-on-taskbar.patch
Patch10: alt-def-session.patch
Patch11: alt-def-key-numlock.patch
Patch12: alt-def-layout-indicator.patch
Patch13: alt-def-taskman.patch
Patch14: alt-def-desktop-icons.patch
Patch15: alt-menu-add-tooltip.patch
Patch16: alt-kicker-custom-btn-img-size.patch
Patch17: alt-users-use-gost-yescrypt.patch
Patch18: alt-keyboard-indicator-uppercase.patch
Patch19: alt-def-screenreader.patch
Patch20: alt-knetattach-test-unlock-ui.patch
# Fix bug #42348
Patch21: alt-re-set-xkb-mappings.patch
Patch22: alt-i18n.patch
Patch23: alt-handle-etc-x11-xinit-xkbmap.patch
Patch24: alt-fix-activity-manager-width.patch

# Automatically added by buildreq on Mon Mar 23 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds docbook-style-xsl elfutils fontconfig fontconfig-devel glib2-devel glibc-devel-static kf5-attica-devel kf5-kdoctools-devel libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXext-devel libXfixes-devel libXft-devel libXi-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXrender-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libcloog-isl4 libdbusmenu-qt52 libfreetype-devel libgpg-error libjson-c libqt5-concurrent libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-printsupport libqt5-qml libqt5-quick libqt5-quickwidgets libqt5-sql libqt5-svg libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libusb-compat libxcb-devel libxcbutil-image libxcbutil-keysyms libxkbfile-devel mkfontscale pkg-config python-base qt5-base-devel rpm-build-gir ruby ruby-stdlibs xml-common xml-utils xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-renderproto-devel xorg-xf86miscproto-devel xorg-xproto-devel
#BuildRequires: boost-devel-headers extra-cmake-modules gcc-c++ iceauth kf5-baloo-devel kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdelibs4support kf5-kdelibs4support-devel kf5-kdesignerplugin-devel kf5-kdoctools kf5-kdoctools-devel kf5-kemoticons-devel kf5-kfilemetadata-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-knotifyconfig-devel kf5-kpackage-devel kf5-kparts-devel kf5-krunner-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwidgetsaddons-devel kf5-kwin-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-libksysguard-devel kf5-plasma-framework-devel kf5-plasma-workspace-devel kf5-solid-devel kf5-sonnet-devel libGLU-devel libcanberra-devel libpulseaudio-devel libusb-compat-devel libxapian-devel libxcbutil-image-devel mkfontdir python-module-google qt5-declarative-devel qt5-phonon-devel qt5-svg-devel qt5-x11extras-devel rpm-build-ruby xset
BuildRequires(pre): rpm-build-kf5
BuildRequires: rpm-build-python3
BuildRequires: boost-devel extra-cmake-modules gcc-c++
BuildRequires: qt5-declarative-devel qt5-phonon-devel qt5-svg-devel qt5-x11extras-devel
%if_enabled scim
BuildRequires: scim-devel
%endif
BuildRequires: libibus-devel libgio-devel glib2-devel
BuildRequires: packagekit-qt-devel
BuildRequires: libudev-devel
BuildRequires: libGLU-devel libcanberra-devel libpulseaudio-devel libusb-compat-devel libxapian-devel
BuildRequires: libxcbutil-devel libxcbutil-image-devel libxkbcommon-devel
BuildRequires: xorg-drv-synaptics-devel xorg-sdk xorg-drv-evdev-devel xkeyboard-config-devel xorg-drv-libinput-devel
BuildRequires: iceauth mkfontdir xset /usr/bin/intltool-merge
BuildRequires: wayland-devel qt5-wayland-devel wayland-protocols kde5-plasma-wayland-protocols
BuildRequires: accounts-qt5-devel kde5-kaccounts-integration-devel signon-devel
BuildRequires: kf5-baloo-devel kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel
BuildRequires: kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel
BuildRequires: kf5-kdbusaddons-devel kf5-kdesignerplugin-devel
BuildRequires: kf5-kdelibs4support kf5-kdelibs4support-devel
BuildRequires: kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-kemoticons-devel kf5-kfilemetadata-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel
BuildRequires: kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel
BuildRequires: kf5-knewstuff-devel kf5-knotifications-devel kf5-knotifyconfig-devel kf5-kpackage-devel kf5-kparts-devel
BuildRequires: kf5-krunner-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel
BuildRequires: kf5-kwidgetsaddons-devel plasma5-kwin-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel plasma5-libksysguard-devel
BuildRequires: kf5-plasma-framework-devel plasma5-workspace-devel kf5-solid-devel kf5-sonnet-devel
BuildRequires: kf5-kdeclarative-devel kf5-kpeople-devel kf5-kactivities-stats-devel
BuildRequires: kf5-kded kf5-kded-devel plasma5-kscreenlocker-devel plasma5-breeze-devel

Provides: kf5-plasma-desktop = %EVR
Obsoletes: kf5-plasma-desktop < %EVR

%description
Plasma desktop view furniture.

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
Provides: kf5-plasma-desktop-common = %EVR
Obsoletes: kf5-plasma-desktop-common < %EVR
%description common
%name common package

%package maxi
Summary: %name maximum package
Group: System/Configuration/Packaging
Requires: %name
%description maxi
%name maximum package.

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common >= %EVR
Provides: kf5-plasma-desktop-devel = %EVR
Obsoletes: kf5-plasma-desktop-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n polkit-kde-plasma-desktop
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name-common >= %EVR
Requires: polkit-kde-plasma-workspace
Provides: polkit-kde-kcmclock
%description -n polkit-kde-plasma-desktop
Common polkit files for %name


%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
#%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
# use-gost-yescrypt
#%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1 -b .xkb
%patch24 -p1

msgcat --use-first po/ru/kcm_componentchooser.po %SOURCE10 > po/ru/kcm_multicomponentchooser.po
cat po/ru/kcm_multicomponentchooser.po > po/ru/kcm_componentchooser.po
msgcat --use-first po/ru/kcm_touchpad.po %SOURCE11 > po/ru/kcm_touchpad.po.tmp
cat po/ru/kcm_touchpad.po.tmp >po/ru/kcm_touchpad.po
rm -f po/ru/kcm_touchpad.po.tmp

pushd kcms
    tar xvf %SOURCE1
popd

# disable krunners by default
for d in runners/*/*.json ; do
    sed -i '/EnabledByDefault/s|true|false|' $d
done
# enable some krunners by default
for d in plasma-desktop
do
    sed -i '/EnabledByDefault/s|false|true|' runners/${d}/plasma-runner-${d}.json
done

#Fix translate in Input Method Panel (kimpanel) widget.
#If the po-file is called differently than "plasma_applet_org.kde.plasma.kimpanel.po", the kimpanel widget menu will be in English only.
#find po/ -maxdepth 2 -name plasma_applet_org.kde.kimpanel.po -type f -exec rename plasma_applet_org.kde.kimpanel.po plasma_applet_org.kde.plasma.kimpanel.po '{}' \;

%build
%K5cmake \
    -DLIBEXEC_INSTALL_DIR=%_K5exec \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    #
%K5make

%install
%K5install

%K5install_move data color-schemes doc kcmmouse knsrcfiles kglobalaccel
%K5install_move data kcm_componentchooser kcminput kcmkeyboard kcmkeys kcm_phonon kcmsolidactions
%K5install_move data kcontrol ksmserver kconf_update solid kpackage
%K5install_move data plasma/desktoptheme plasma/plasmoids/touchpad plasma/emoji

%find_lang %name --with-kde --all-name


%files common -f %name.lang
%doc LICENSES/*
%_datadir/locale/*/LC_SCRIPTS/kfontinst/
%_K5icon/*/*/*/*.*
%_datadir/qlogging-categories5/*.*categories

%files
%_K5dbus/system.d/*.conf
%_K5bin/*
%exclude %_K5bin/*emojier*
%_K5exec/*
%_K5libexecdir/kauth/*
%_K5plug/*.so
%_K5plug/kcms/*.so
%_K5plug/kf5/kded/*.so
%_K5plug/kf5/krunner/*.so
%_K5plug/plasma/dataengine/*.so
%_K5plug/plasma/kcminit/
%_K5plug/plasma/kcms/*/*.so
%_K5qml/org/kde/activities/settings/
%_K5qml/org/kde/plasma/private/*/
%_K5qml/org/kde/private/*/
%_K5qml/org/kde/plasma/activityswitcher/
%_K5qml/org/kde/plasma/emoji/
%_K5xdgapp/*
%exclude %_K5xdgapp/*emojier*
%_K5start/*.desktop
%_K5cfg/*
%_K5conf_up/*
%_K5srv/*.desktop
%_K5srvtyp/*.desktop
%_K5notif/*
%_K5data/solid/devices/solid-*.desktop
%_K5data/kcm*/
%_kf5_data/kcm*/
%_kf5_data/kactivitymanagerd/
%_K5data/kpackage/kcms/*
%_K5data/plasma/emoji/
%_kf5_data/plasma/plasmoids/*
%_kf5_data/plasma/packages/*
%_kf5_data/plasma/layout-templates/*
%_kf5_data/plasma/shells/*/
%_kf5_data/plasma/services/*
%_K5data/plasma/desktoptheme/default/icons/*
%_K5data/kglobalaccel/*.desktop
%exclude %_K5data/kglobalaccel/*emojier*.desktop
%_K5data/knsrcfiles/*.knsrc
%_K5dbus_sys_srv/*.service
%_datadir/accounts/providers/kde/*.provider
%_datadir/accounts/services/kde/*.service
%_datadir/metainfo/*.xml

%files maxi
%_K5bin/*emojier*
%_K5xdgapp/*emojier*
%_K5data/kglobalaccel/*emojier*.desktop

%files -n polkit-kde-plasma-desktop
%_datadir/polkit-1/actions/*kcmclock*.policy

%files devel
#%_K5link/lib*.so
%_K5dbus_iface/*.xml

%changelog
