%define rname kscreenlocker

%def_disable seccomp

%define sover 5
%define libkscreenlocker libkscreenlocker%sover

Name: plasma5-%rname
Version: 5.27.11
Release: alt2
Epoch: 2
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 Screen Locker
Url: http://www.kde.org
License: GPL-2.0-or-later

Requires: plasma5-layer-shell-qt

Provides: kf5-kscreenlocker = %EVR
Obsoletes: kf5-kscreenlocker < %EVR

Source: %rname-%version.tar
Source2: kcheckpass.tar
Source10: pam-kf5-screenlocker
Patch1: alt-def-screenlocker.patch
Patch2: alt-pam-support.patch

BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: glibc-devel
BuildRequires: extra-cmake-modules gcc-c++ qt5-base-devel qt5-declarative-devel qt5-x11extras-devel
BuildRequires: libpam-devel libwayland-client-devel libwayland-server-devel
%if_enabled seccomp
BuildRequires: libseccomp-devel
%endif
BuildRequires: kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel
BuildRequires: kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel
BuildRequires: kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdesignerplugin-devel
BuildRequires: kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-kemoticons-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel
BuildRequires: kf5-kidletime-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel
BuildRequires: kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kpackage-devel kf5-kparts-devel kf5-kservice-devel
BuildRequires: kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel
BuildRequires: kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-plasma-framework-devel kf5-solid-devel kf5-sonnet-devel
BuildRequires: plasma5-layer-shell-qt-devel plasma5-libkscreen-devel

%description
%summary

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
Provides: kf5-kscreenlocker-common = %EVR
Obsoletes: kf5-kscreenlocker-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Provides: kf5-kscreenlocker-devel = %EVR
Obsoletes: kf5-kscreenlocker-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n %libkscreenlocker
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
%description -n %libkscreenlocker
KF5 library


%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1

tar xf %SOURCE2 kcheckpass/
mv kcheckpass/authenticator.* greeter/
mv kcheckpass/config-unix.h.cmake ./

mkdir bin_fake
ln -s /bin/true bin_fake/loginctl

%build
export PATH=$PWD/bin_fake:$PATH
%K5build \
    -DINCLUDE_INSTALL_DIR=%_K5inc \
    -DKDE4_KSCREENSAVER_PAM_SERVICE="kf5-screenlocker" \
    -DKDE_KSCREENSAVER_PAM_SERVICE="kf5-screenlocker" \
    -DKSCREENSAVER_PAM_SERVICE="kf5-screenlocker" \
    #

%install
%K5install
%K5install_move data kconf_update ksmserver kpackage
%find_lang %name --all-name

# Install kde pam configuration files
install -d -m 0755 %buildroot/%_sysconfdir/pam.d/
install -m 0644 %SOURCE10 %buildroot/%_sysconfdir/pam.d/kf5-screenlocker

%files common -f %name.lang
%doc COPYING
%_datadir/qlogging-categories5/*.*categories

%files
%config(noreplace) %_sysconfdir/pam.d/kf5-screenlocker
%attr(2711,root,chkpwd) %_K5libexecdir/kcheckpass
%_K5libexecdir/kscreenlocker_greet
%_K5plug/plasma/kcms/systemsettings/*screenlocker*.so
%_K5data/ksmserver/screenlocker/
%_K5data/kpackage/kcms/kcm_screenlocker/
%_K5conf_up/k*reenlock*
%_K5notif/*.notifyrc
%_K5xdgapp/*screenlocker*.desktop

%files devel
#%_K5inc/kscreenlocker_version.h
%_K5inc/KScreenLocker/
%_K5link/lib*.so
%_K5lib/cmake/KScreenLocker/
%_K5lib/cmake/ScreenSaverDBusInterface/
%_K5dbus_iface/*creen?aver*.xml

%files -n %libkscreenlocker
%_K5lib/libKScreenLocker.so.*
%_K5lib/libKScreenLocker.so.%sover

%changelog
