%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif

%define rname kwin

%define kwin_sover 5
%define libkwin libkwin%kwin_sover
%define kcmkwincommon_sover 5
%define libkcmkwincommon libkcmkwincommon%kcmkwincommon_sover
%define kwineffects_sover 14
%define libkwineffects libkwineffects%kwineffects_sover
%define kwinglutils_sover 14
%define libkwinglutils libkwinglutils%kwinglutils_sover
%define kwinxrenderutils_sover 14
%define libkwinxrenderutils libkwinxrenderutils%kwinxrenderutils_sover

Name: plasma5-%rname
Version: 5.27.11
Release: alt4
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 Window Manager
Url: http://www.kde.org
License: GPL-2.0-or-later

Provides: kf5-kwin = %EVR
Obsoletes: kf5-kwin < %EVR

Requires: hwdata
Requires: /usr/bin/Xwayland kf5-kirigami plasma5-kscreenlocker
Requires: qml(QtMultimedia) qml(QtQuick.VirtualKeyboard) qt5-quickcontrols qt5-quickcontrols2
Requires: qml(org.kde.kquickcontrols) qml(org.kde.plasma.components) qml(org.kde.plasma.core)
Requires(post): /sbin/setcap

Source: %rname-%version.tar
#
Patch1: alt-def-window-buttons.patch
Patch2: alt-def-nocompositing.patch
Patch3: alt-def-qcompositing.patch
#
Patch5: alt-def-xkb.patch
Patch6: alt-def-layout-switch.patch

# Automatically added by buildreq on Thu Mar 05 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds docbook-style-xsl elfutils glibc-devel-static kf5-attica-devel kf5-kdoctools-devel libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXext-devel libXfixes-devel libXft-devel libXi-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXrender-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libcloog-isl4 libgpg-error libjson-c libqt5-concurrent libqt5-core libqt5-dbus libqt5-gui libqt5-multimedia libqt5-network libqt5-printsupport libqt5-qml libqt5-quick libqt5-quickwidgets libqt5-script libqt5-sql libqt5-svg libqt5-test libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libudev-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl libxcb-devel libxcbutil-icccm libxcbutil-image libxcbutil-keysyms libxcbutil-keysyms-devel libxkbfile-devel pkg-config python-base qt5-base-devel qt5-declarative-devel qt5-tools-devel ruby ruby-stdlibs wayland-devel xml-common xml-utils xorg-kbproto-devel xorg-xextproto-devel xorg-xf86miscproto-devel xorg-xf86vidmodeproto-devel xorg-xproto-devel
#BuildRequires: extra-cmake-modules gcc-c++ kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdecoration-devel kf5-kdelibs4support kf5-kdoctools kf5-kdoctools-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-kpackage-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-plasma-framework-devel kf5-solid-devel kf5-sonnet-devel libepoxy-devel libinput-devel libwayland-cursor-devel libwayland-egl-devel libwayland-server-devel libxcbutil-icccm-devel libxcbutil-image-devel libxkbcommon-devel python-module-google qt5-multimedia-devel qt5-script-devel qt5-tools-devel-static qt5-x11extras-devel rpm-build-gir rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 libwayland-client-devel
BuildRequires: rpm-build-python3
BuildRequires: extra-cmake-modules gcc-c++ qt5-base-devel-static qt5-declarative-devel
BuildRequires: libqaccessibilityclient-qt5-devel
BuildRequires: libcap-utils libcap-devel zlib-devel
BuildRequires: libxcbutil-devel libxcbutil-icccm-devel libxcbutil-image-devel libxcbutil-cursor-devel libxcbutil-keysyms-devel
BuildRequires: libxkbcommon-devel libxkbcommon-x11-devel libgbm-devel libdrm-devel libEGL-devel libxcvt-devel
BuildRequires: fontconfig-devel libfreetype-devel liblcms2-devel
BuildRequires: libepoxy-devel libinput-devel libwayland-cursor-devel libwayland-egl-devel libwayland-server-devel
BuildRequires: pipewire-libs-devel
BuildRequires: hwdata-devel
BuildRequires: qt5-wayland-devel kde5-plasma-wayland-protocols wayland-protocols
BuildRequires: qt5-multimedia-devel qt5-script-devel qt5-tools-devel-static qt5-x11extras-devel qt5-sensors-devel
BuildRequires: kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel
BuildRequires: kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel
BuildRequires: kf5-kdbusaddons-devel kf5-kdeclarative-devel plasma5-kdecoration-devel kf5-kdelibs4support
BuildRequires: kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel
BuildRequires: kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-kpackage-devel
BuildRequires: kf5-kservice-devel kf5-ktextwidgets-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel
BuildRequires: kf5-kxmlgui-devel kf5-plasma-framework-devel kf5-solid-devel kf5-sonnet-devel kf5-kidletime-devel
BuildRequires: kf5-kirigami-devel kf5-krunner-devel
BuildRequires: plasma5-kscreenlocker-devel plasma5-breeze-devel

%description
KDE Window Manager

%package common
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: kf5-filesystem
Provides: kf5-kwin-common = %EVR
Obsoletes: kf5-kwin-common < %EVR
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Provides: kf5-kwin-devel = %EVR
Obsoletes: kf5-kwin-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n %libkwin
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
Requires: libwayland-client = %{get_version libwayland-client-devel}
%description -n %libkwin
KF5 library

%package -n %libkcmkwincommon
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
%description -n %libkcmkwincommon
KF5 library

%package -n %libkwineffects
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
%description -n %libkwineffects
KF5 library

%package -n %libkwinglutils
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
%description -n %libkwinglutils
KF5 library

%package -n %libkwinxrenderutils
Group: System/Libraries
Summary: KF5 library
Requires: %name-common >= %EVR
%description -n %libkwinxrenderutils
KF5 library

%prep
%setup -n %rname-%version
%patch1 -p1
#%patch2 -p1 -b .nocompositing
#%patch3 -p1 -b .qcompositing
#
#%patch5 -p1 -b .xkb
%patch6 -p1

for f in src/kcms/compositing/kwincompositing.json ; do
    sed -i '/X-DocPath/d' $f
done

%build
%K5build \
    -DINCLUDE_INSTALL_DIR=%_K5inc \
    -DLIBEXEC_INSTALL_DIR=%_K5exec \
    -DDATA_INSTALL_DIR=%_K5data \
    #

%install
%K5install
%K5install_move data kconf_update knsrcfiles krunner
%find_lang %name --with-kde --all-name

%post
/sbin/setcap CAP_SYS_NICE=+ep %_K5bin/kwin_wayland ||:

%files common -f %name.lang
%doc LICENSES/*
%_K5icon/*/*/apps/*.*

%files
%_datadir/qlogging-categories5/*.*categories
%_K5bin/kwin*
%_K5exec/*kwin*
%_K5plug/kpackage/packagestructure/kwin_*.so
%_K5plug/kwin/
%_K5plug/plasma/kcms/systemsettings/*kwin*.so
%_K5plug/plasma/kcms/systemsettings/*virtua*.so
%_K5plug/plasma/kcms/systemsettings_qwidgets/*kwin*.so
%_K5plug/org.kde.kdecoration2/
%_K5xdgapp/*kwin*.desktop
%_K5xdgapp/*virtua*.desktop
%_K5cf_bin/kwin*
%_K5conf_up/kwin*
%_K5qml/org/kde/kwin*/
%_K5cfg/*.kcfg
%_K5data/kpackage/kcms/kcm_*/
%_K5data/kwin/
%_K5data/knsrcfiles/*.knsrc
%_K5data/krunner/dbusplugins/*.desktop
#%_K5srv/kwin/
%_K5srvtyp/*.desktop
%_K5notif/*.notifyrc
%_unitdir_user/*.service

%files devel
%_K5inc/kwin*.h
%_K5link/lib*.so
%_K5lib/cmake/KWin*/
%_K5dbus_iface/*.xml

%files -n %libkwineffects
%_K5lib/libkwineffects.so.%kwineffects_sover
%_K5lib/libkwineffects.so.*
%files -n %libkwinglutils
%_K5lib/libkwingl*utils.so.%kwinglutils_sover
%_K5lib/libkwingl*utils.so.*
%files -n %libkwin
%_K5lib/libkwin.so.%kwin_sover
%_K5lib/libkwin.so.*
#%files -n %libkwinxrenderutils
#%_K5lib/libkwinxrenderutils.so.%kwinxrenderutils_sover
#%_K5lib/libkwinxrenderutils.so.*
%files -n %libkcmkwincommon
%_K5lib/libkcmkwincommon.so.%kcmkwincommon_sover
%_K5lib/libkcmkwincommon.so.*


%changelog
