%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%ifndef _unitdir_user
%define _unitdir_user %prefix/lib/systemd/user
%endif

%define rname plasma-workspace

%define x11confdir %_sysconfdir/X11

%define kworkspace5_sover 5
%define libkworkspace5 libkworkspace5%kworkspace5_sover
%define plasma_geolocation_interface_sover 5
%define libplasma_geolocation_interface libplasma-geolocation-interface%plasma_geolocation_interface_sover
%define taskmanager_sover 6
%define libtaskmanager libtaskmanager%taskmanager_sover
%define weather_ion_sover 7
%define libweather_ion libweather_ion%weather_ion_sover
%define colorcorrect_sover 5
%define libcolorcorrect libcolorcorrect%colorcorrect_sover
%define notificationmanager_sover 1
%define libnotificationmanager libnotificationmanager%notificationmanager_sover
%define kfontinst_sover 5
%define libkfontinst libkfontinst%kfontinst_sover
%define kfontinstui_sover 5
%define libkfontinstui libkfontinstui%kfontinstui_sover
%define krdb_sover 5
%define libkrdb libkrdb%krdb_sover

%def_enable qalculate
%_K5if_ver_gteq %ubt_id M90
%def_enable appstream
%else
%def_disable appstream
%endif

Name: plasma5-workspace
Version: 5.27.11
Release: alt11
Epoch: 1
%K5init

Group: Graphical desktop/KDE
Summary: KDE Workspace 5 Plasma
Url: http://www.kde.org
License: GPL-2.0-or-later

Provides: kf5-plasma-workspace = %EVR
Obsoletes: kf5-plasma-workspace < %EVR
Provides: plasma5-user-manager = %EVR
Obsoletes: plasma5-user-manager < %EVR

#Requires: kde5-kio-fuse
Requires: %name-qml
Requires: /usr/share/design/current xdg-user-dirs
Requires: iso-codes
Requires: xmessage
Requires: qt5-dbus qt5-tools qt5-quickcontrols qt5-virtualkeyboard dbus-tools-gui
Requires: kf5-kinit kf5-kconfig kf5-kded kf5-kglobalaccel kf5-kdeclarative
Requires: kf5-kwallet kf5-solid kf5-kimageformats kf5-kdbusaddons kf5-kio kf5-kio-extras
Requires: kf5-kquickcharts kf5-kirigami
Requires: plasma5-polkit-kde-agent plasma5-kwin plasma5-kactivitymanagerd
Requires: plasma5-kpipewire

Source: %rname-%version.tar
Source1: freememorynotifier.po
Source2: libkicker-ru-add.po
Source3: plasma_lookandfeel_org.kde.lookandfeel-ru-add.po
#
Source11: freememorynotifier.tar
Source40: ssh-agent.conf
Source41: spice-vdagent.conf
Source42: obex.conf
Source43: xdg-user-dirs.conf
#
Source50: dbus-restart-kde5.sh
Source51: nvidia_prime_available.cpp

Patch1: 0001-Check_actual_battery_for_charge_state-workaround.patch
Patch2: 0002-Fix_writing_ICEAuthority_file.patch
#
Patch100: alt-startkde.patch
Patch101: alt-menu-add-tooltip.patch
Patch102: alt-def-wallpaper-image.patch
Patch103: alt-wait-drkonqi.patch
Patch104: alt-def-digital-clock.patch
Patch105: alt-lock-widgets.patch
Patch106: alt-digital-clock-date.patch
Patch107: alt-freespacenotifier.patch
Patch108: alt-def-background.patch
Patch109: alt-def-start-empty-session.patch
Patch110: alt-breeze-loginscreen-focus.patch
Patch111: alt-breeze-one-screen.patch
Patch112: alt-breeze-pw-renew.patch
Patch113: alt-breeze-autoupdate-username.patch
Patch114: alt-menu-search-results-add-genericname.patch
Patch115: alt-dbus-sessionchange.patch
#Patch116: alt-refresh-menu.patch
Patch117: alt-klipper-help-url.patch
Patch118: alt-session-exclude.patch
Patch119: alt-freespace-thread-timer.patch
Patch120: alt-desktop-plasmashell.patch
Patch121: alt-freememorynotifier.patch
Patch122: alt-systemmonitor-ignoreconfig.patch
Patch123: alt-def-font.patch
Patch124: alt-filtering-widget-settings-upon-first-launch.patch
Patch125: alt-translate-keyboard-layouts.patch
Patch126: alt-add-using-the-altappstarter.patch
Patch127: alt-plasma-5.17-crash.patch
Patch128: alt-soname.patch
Patch129: alt-def-icons.patch
Patch130: alt-sddm-check-username.patch
Patch131: alt-kscreenlocker-theme-pam-support.patch
Patch132: alt-fix-virtualkeyboard.patch
Patch133: alt-dont-remove-desktop-actions.patch
Patch134: alt-zonetab.patch
Patch135: alt-fix-virtualkeyboard-size.patch
Patch136: alt-users-use-gost-yescrypt.patch
Patch137: alt-systemd-boot.patch
Patch138: alt-digital-clock-tz.patch
Patch139: alt-locales-list.patch
Patch140: alt-watch-wallpaper.patch
Patch141: alt-weather-fix-ua.patch
Patch142: alt-fix-lockout-applet.patch
Patch143: alt-run-etc-profile.patch
Patch144: alt-def-lookandfeel.patch
Patch145: alt-add-nvidia-prime-to-menu.patch
Patch146: alt-fix-wallpaper-confirmation.patch
Patch147: alt-fix-kcm-regionlanguage-reset-default.patch
Patch148: alt-kcm-nightcolor-fixes.patch
Patch149: alt-appstream-1.patch
Patch150: alt-kcmusers-avatars.patch
Patch151: alt-fix-display-icons-subcategories.patch
Patch152: alt-fix-installation-widget-from-file.patch

# Automatically added by buildreq on Sat Mar 21 2015 (-bi)
# optimized out: cmake cmake-modules docbook-dtds docbook-style-xsl elfutils fontconfig glib2-devel glibc-devel-static kf5-attica-devel kf5-kdoctools-devel kf5-kjs-devel libEGL-devel libGL-devel libICE-devel libSM-devel libX11-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdamage-devel libXdmcp-devel libXext-devel libXfixes-devel libXft-devel libXi-devel libXinerama-devel libXmu-devel libXpm-devel libXrandr-devel libXrender-devel libXt-devel libXtst-devel libXv-devel libXxf86misc-devel libXxf86vm-devel libcln-devel libcloog-isl4 libdbusmenu-qt52 libgpg-error libgst-plugins1.0 libjson-c libqt5-concurrent libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-opengl libqt5-printsupport libqt5-qml libqt5-quick libqt5-quickwidgets libqt5-script libqt5-sql libqt5-svg libqt5-test libqt5-webkit libqt5-webkitwidgets libqt5-widgets libqt5-x11extras libqt5-xml libstdc++-devel libwayland-client libwayland-server libxcb-devel libxcbutil-keysyms libxcbutil-keysyms-devel libxkbfile-devel libxml2-devel pkg-config python-base qt5-base-devel qt5-declarative-devel qt5-webkit-devel rpm-build-gir ruby ruby-stdlibs wayland-devel xml-common xml-utils xorg-fixesproto-devel xorg-kbproto-devel xorg-renderproto-devel xorg-xf86miscproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: extra-cmake-modules gcc-c++ iceauth kf5-baloo-devel kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel kf5-kdelibs4support kf5-kdelibs4support-devel kf5-kdesignerplugin-devel kf5-kdesu-devel kf5-kdewebkit-devel kf5-kdoctools kf5-kdoctools-devel kf5-kemoticons-devel kf5-kfilemetadata-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kidletime-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-kjsembed-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-knotifyconfig-devel kf5-kpackage-devel kf5-kparts-devel kf5-kpty-devel kf5-krunner-devel kf5-kservice-devel kf5-ktexteditor-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel kf5-kwin-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-libkscreen-devel kf5-libksysguard-devel kf5-plasma-framework-devel kf5-solid-devel kf5-sonnet-devel libdbusmenu-qt5-devel libgps-devel libpam-devel libqalculate-devel libwayland-client-devel libwayland-server-devel libxapian-devel mkfontdir prison-devel python-module-google qt5-phonon-devel qt5-script-devel qt5-x11extras-devel rpm-build-ruby xmessage xprop xrdb xset xsetroot zlib-devel-static
BuildRequires(pre): rpm-build-kf5 rpm-build-ubt
BuildRequires: extra-cmake-modules gcc-c++
BuildRequires: qt5-base-devel-static qt5-phonon-devel qt5-script-devel qt5-svg-devel qt5-x11extras-devel qt5-wayland-devel
BuildRequires: libgps-devel libpam0-devel zlib-devel libpolkitqt5-qt5-devel
%if_enabled qalculate
BuildRequires: libqalculate-devel
%endif
%if_enabled appstream
BuildRequires: appstream-qt-devel
%endif
BuildRequires: libwayland-client-devel libwayland-server-devel libdrm-devel
BuildRequires: pipewire-libs-devel
BuildRequires: libxapian-devel libnm-devel libsysfs-devel
BuildRequires: libxcbutil-image-devel libxcbutil-devel
BuildRequires: iceauth xmessage xprop xrdb xset xsetroot
BuildRequires: kf5-baloo-devel kf5-kactivities-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcmutils-devel
BuildRequires: kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel
BuildRequires: kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdeclarative-devel
BuildRequires: kf5-kdelibs4support kf5-kdelibs4support-devel
BuildRequires: kf5-kdesignerplugin-devel kf5-kdesu-devel kf5-kdoctools kf5-kdoctools-devel
BuildRequires: kf5-kemoticons-devel kf5-kfilemetadata-devel kf5-kglobalaccel-devel kf5-kguiaddons-devel kf5-ki18n-devel
BuildRequires: kf5-kiconthemes-devel kf5-kidletime-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel
BuildRequires: kf5-kjobwidgets-devel kf5-kjsembed-devel kf5-knewstuff-devel kf5-knotifications-devel kf5-knotifyconfig-devel
BuildRequires: kf5-kpackage-devel kf5-kparts-devel kf5-kpty-devel kf5-krunner-devel kf5-kservice-devel kf5-ktexteditor-devel
BuildRequires: kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwayland-devel kf5-kwidgetsaddons-devel
BuildRequires: kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-plasma-framework-devel
BuildRequires: kf5-solid-devel kf5-sonnet-devel kf5-kxmlrpcclient-devel kf5-prison-devel
BuildRequires: kf5-networkmanager-qt-devel kf5-kpeople-devel kf5-kactivities-stats-devel
BuildRequires: kf5-kded kf5-kded-devel
BuildRequires: kde5-kholidays-devel kde5-libkexiv2-devel
BuildRequires: wayland-protocols kde5-plasma-wayland-protocols
BuildRequires: plasma5-kscreenlocker-devel plasma5-breeze-devel plasma5-layer-shell-qt-devel
BuildRequires: plasma5-kpipewire-devel plasma5-kwin-devel plasma5-libkscreen-devel plasma5-libksysguard-devel
 
%description
KDE Plasma Workspace

%package common
Summary: %name common package
Group: System/Configuration/Other
Requires: kf5-filesystem
Provides: kf5-plasma-workspace-common = %EVR
Obsoletes: kf5-plasma-workspace-common < %EVR
Conflicts: plasma5-desktop-common < 5.20
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Provides: kf5-plasma-workspace-devel = %EVR
Obsoletes: kf5-plasma-workspace-devel < %EVR
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n %name-qml
Group: Graphical desktop/KDE
Summary: Base qml-components for plasma workspace
Requires: %name-common >= %EVR
Requires: qml(QtGraphicalEffects)
Requires: qml(org.kde.plasma.core) qml(org.kde.kquickcontrols) qml(org.kde.kirigami) qml(org.kde.kwin)
%description -n %name-qml
Base qml-components for plasma workspace

%package -n sddm-theme-breeze
Group: Graphical desktop/KDE
Summary: SDDM breeze theme
Requires: libkf5plasmaquick
Requires: %name-common >= %EVR
Requires: %name-qml >= %EVR
Buildarch: noarch
%description -n sddm-theme-breeze
SDDM breeze theme

%package -n polkit-kde-plasma-workspace
Summary: %name common package
Group: System/Configuration/Other
BuildArch: noarch
Requires: %name-common >= %EVR
Provides: polkit-kde-kfontinst
%description -n polkit-kde-plasma-workspace
Common polkit files for %name

%package -n %libkworkspace5
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Provides: libkworkspace5 = %version-%release
Obsoletes: libkworkspace5 < %version-%release
%description -n %libkworkspace5
%name library

%package -n %libplasma_geolocation_interface
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Provides: libplasma_geolocation_interface = %version-%release
Obsoletes: libplasma_geolocation_interface < %version-%release
%description -n %libplasma_geolocation_interface
%name library

%package -n %libtaskmanager
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Provides: libtaskmanager = %version-%release
Obsoletes: libtaskmanager < %version-%release
%description -n %libtaskmanager
%name library

%package -n %libweather_ion
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
Provides: libweather_ion = %version-%release
Obsoletes: libweather_ion < %version-%release
%description -n %libweather_ion
%name library

%package -n %libcolorcorrect
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libcolorcorrect
%name library

%package -n %libnotificationmanager
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libnotificationmanager
%name library

%package -n %libkfontinst
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libkfontinst
%name library

%package -n %libkfontinstui
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libkfontinstui
%name library

%package -n %libkrdb
Group: System/Libraries
Summary: %name library
Requires: %name-common >= %EVR
%description -n %libkrdb
%name library


%prep
%setup -n %rname-%version
%patch1 -p1
%patch2 -p1
#
%patch100 -p1 -b .startkde
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
###%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
pushd lookandfeel/sddm-theme
%patch112 -p1
popd
%patch113 -p1
%patch114 -p1
%patch115 -p1
#%patch116 -p1
%patch117 -p1
%patch118 -p1
%patch119 -p2
%patch120 -p1
%patch121 -p2
#%patch122 -p2
%patch123 -p1
#%patch124 -p1
%patch125 -p1
%patch126 -p1
%patch127 -p2
%patch128 -p1
%patch129 -p1
%patch130 -p1
%patch131 -p2 -b .theme_pam
%patch132 -p1
%patch133 -p1
%patch134 -p1
%patch135 -p2
%patch136 -p1
%patch137 -p1
%patch138 -p1
%patch139 -p1
%patch140 -p1
%patch141 -p1
%patch142 -p1
%patch143 -p1
%patch144 -p1
%patch145 -p1 -b .prime
%patch146 -p1
%patch147 -p1
%patch148 -p1
%patch149 -p1
%patch150 -p1
%patch151 -p1
%patch152 -p1

pwd
install -m0644 %SOURCE51 applets/kicker/plugin/

install -m 0644 %SOURCE1 po/ru/freememorynotifier.po
tar xf %SOURCE11 freememorynotifier/
msgcat --use-first po/ru/libkicker.po %SOURCE2 > po/ru/libkicker.po.tmp
cat po/ru/libkicker.po.tmp > po/ru/libkicker.po
rm -f po/ru/libkicker.po.tmp
msgcat --use-first po/ru/plasma_lookandfeel_org.kde.lookandfeel.po %SOURCE3 > po/ru/plasma_lookandfeel_org.kde.lookandfeel.po.tmp
cat po/ru/plasma_lookandfeel_org.kde.lookandfeel.po.tmp > po/ru/plasma_lookandfeel_org.kde.lookandfeel.po
rm -f po/ru/plasma_lookandfeel_org.kde.lookandfeel.po.tmp

# disable find PackageKitQt5
sed -i 's|PackageKitQt5|PackageKitQt5_UBUNTU_ONLY|' CMakeLists.txt

# disable krunners by default
for d in runners/*/*.desktop ; do
    sed -i 's|^X-KDE-PluginInfo-EnabledByDefault=.*$|X-KDE-PluginInfo-EnabledByDefault=false|' $d
done
for d in runners/*/*.json ; do
    sed -i '/EnabledByDefault/s|true|false|' $d
done
# enable some krunners by default
#for d in appstream services shell
#do
#    sed -i 's|^X-KDE-PluginInfo-EnabledByDefault=.*$|X-KDE-PluginInfo-EnabledByDefault=true|' runners/${d}/plasma-runner-${d}.desktop
#done
for d in appstream services shell
do
    sed -i '/EnabledByDefault/s|false|true|' runners/${d}/plasma-runner-${d}.json
done

%build
%K5build \
    -DINCLUDE_INSTALL_DIR=%_K5inc \
    -DLIBEXEC_INSTALL_DIR=%_K5exec \
    -DKDE4_COMMON_PAM_SERVICE="kf5" \
    -DKDE_COMMON_PAM_SERVICE="kf5" \
    -DUBUNTU_PACKAGEKIT:BOOL=OFF \
    -DGLIBC_LOCALE_GENERATED:BOOL=ON \
    -DGLIBC_LOCALE_GEN:BOOL=OFF \
    #

%install
%K5install
%K5install_move data kstyle solid kdevappwizard kpackage kglobalaccel
%K5install_move data desktop-directories doc kconf_update kio_desktop knsrcfiles
%K5install_move data kcontrol kdisplay kfontinst krunner konqsidebartng plasma/avatars locale
%K5install_move data plasma//nightcolor kio

# fix dbus service
sed -i 's|^Exec=.*|Exec=%_K5bin/krunner|' %buildroot/%_K5dbus_srv/org.kde.krunner.service

mkdir -p %buildroot/%_K5xdgconf/plasma-workspace/env/
mkdir -p %buildroot/%_K5data/kio_desktop/DesktopLinks/

mkdir -p %buildroot/%_bindir
mkdir -p %buildroot/%_kf5_bin
ln -s `relative %_K5bin/startplasma-x11 %_bindir/startkde5` %buildroot/%_bindir/startkde5
ln -s `relative %_K5bin/startplasma-x11 %_kf5_bin/startkde5` %buildroot/%_kf5_bin/startkde5
install -m0755 /dev/null %buildroot/%_bindir/dbus-restart-kde5
%_K5if_ver_gteq %ubt_id M110
# not need to restart dbus
echo -e '#!/bin/sh\n# Not need to restart user dbus when all services in standard place' >%buildroot/%_bindir/dbus-restart-kde5
%else
cat %SOURCE50 >%buildroot/%_bindir/dbus-restart-kde5
%endif

# Add chksession support
mkdir -p %buildroot/%x11confdir/wmsession.d/
cat <<__EOF__ > %buildroot/%x11confdir/wmsession.d/01PLASMA
NAME=Plasma
DESC=Plasma by KDE
ICON=%_K5icon/hicolor/48x48/apps/kwin.png
EXEC=%_K5bin/startplasma-x11
SCRIPT:
exec %_K5bin/startplasma-x11
__EOF__


# Create menu session
mkdir -p %buildroot/%_menudir/
cat <<__EOF__ > %buildroot/%_menudir/kde5-session
?package(%name): needs=wm \
                        section="Session/Windowmanagers" \
			title="PLASMA" \
			longtitle="Plasma by KDE" \
			command="%_bindir/startplasma-x11" \
			icon="kwin.png"
__EOF__

# systemd user service deps
mkdir -p %buildroot/%_unitdir_user/plasma-core.target.d/
mkdir -p %buildroot/%_unitdir_user/plasma-workspace@.target.d/
install -m0644 -p -D %SOURCE40 %buildroot/%_unitdir_user/plasma-core.target.d/ssh-agent.conf
install -m0644 -p -D %SOURCE41 %buildroot/%_unitdir_user/plasma-core.target.d/spice-vdagent.conf
install -m0644 -p -D %SOURCE42 %buildroot/%_unitdir_user/plasma-core.target.d/obex.conf
install -m0644 -p -D %SOURCE43 %buildroot/%_unitdir_user/plasma-core.target.d/xdg-user-dirs.conf

%find_lang %name --with-kde --all-name


%files common -f %name.lang
%doc LICENSES/*
%dir %_kf5_data/plasma/look-and-feel/
%dir %_K5xdgconf/plasma-workspace/
%dir %_K5xdgconf/plasma-workspace/env/
%dir %_K5data/kio_desktop/DesktopLinks/
%dir %_K5plug/kpackage/
%dir %_K5qml/org/kde/plasma/workspace/
%dir %_K5qml/org/kde/plasma/private/
%dir %_K5qml/org/kde/plasma/wallpapers/
%config(noreplace) %_K5xdgconf/*rc
%_datadir/qlogging-categories5/*.*categories
%_K5icon/hicolor/*/mimetypes/*.*
%_K5icon/hicolor/*/apps/*.*

%files
%config(noreplace) %x11confdir/wmsession.d/*PLASMA*
%_menudir/kde5-session
%dir %_K5plug/plasma/
%dir %_K5plug/plasma/*/
%dir %_K5plug/phonon_platform/
%_bindir/*
%_kf5_bin/*
%_K5exec/*
%_K5libexecdir/kauth/*
%_K5conf_bin/*
%_K5plug/kf5/thumbcreator/
%_K5plug/plasma/*/*.so
%_K5plug/phonon_platform/*.so
%_K5plug/*.so
%_K5plug/kpackage/*
%exclude %_K5plug/kpackage/packagestructure/plasma_wallpaper.so
%_K5plug/kf5/kded/*.so
%_K5plug/kf5/kio/*.so
%_K5plug/kf5/krunner/
%_K5plug/kf5/parts/*.so
%_K5plug/plasmacalendarplugins/
%_K5plug/plasma/kcms/systemsettings/
%_K5plug/plasma/kcms/systemsettings_qwidgets/
%_K5qml/org/kde/taskmanager/
%_K5qml/org/kde/holidayeventshelperplugin/
%_K5qml/org/kde/colorcorrect/
%_K5qml/org/kde/notificationmanager/
%_K5data/knsrcfiles/*.knsrc
%_kf5_data/plasma/
%_K5data/plasma/
%exclude %_kf5_data/plasma/look-and-feel/*
%exclude %_kf5_data/plasma/wallpapers/org.kde.image/
%_K5data/kglobalaccel/*.desktop
%_K5data/kio/servicemenus/*
%_K5data/kio_desktop/
%_K5data/kpackage/kcms/*/
%_K5data/krunner/
%_K5data/kstyle/
%_K5data/kfontinst/
%_K5data/konqsidebartng/
%_K5data/desktop-directories/*
%_K5data/solid/actions/*.desktop
%_K5xdgapp/*.desktop
%_K5start/*.desktop
%_K5notif/*.notifyrc
%_K5cfg/*.kcfg
%_K5srv/*.desktop
%_K5srvtyp/*.desktop
%_K5dbus_srv/*.service
%_K5dbus/system.d/*.conf
%_K5dbus_sys_srv/*.service
%_K5conf_up/*
%_datadir/xsessions/plasma.desktop
%_K5if_ver_gteq %ubt_id M90
%_datadir/wayland-sessions/plasmawayland.desktop
%endif
%_K5srv/ServiceMenus/*.desktop
%_K5xmlgui/*/
%dir %_unitdir_user/plasma-core.target.d/
%_unitdir_user/plasma-core.target.d/*.conf
%dir %_unitdir_user/plasma-workspace@.target.d/
%_unitdir_user/*.service
%_unitdir_user/*.target
%_datadir/zsh/site-functions/_*
%_datadir/metainfo/*.xml

%files -n polkit-kde-plasma-workspace
%_datadir/polkit-1/actions/*fontinst*.policy

%files -n %name-qml
%_K5plug/kpackage/packagestructure/plasma_wallpaper.so
%_K5qml/org/kde/plasma/
%_kf5_data/plasma/look-and-feel/*
%_kf5_data/plasma/wallpapers/org.kde.image/

%files -n sddm-theme-breeze
%_datadir/sddm/themes/breeze/

%files devel
%_K5inc/*
%_K5link/lib*.so
%_K5lib/cmake/KRunnerAppDBusInterface/
%_K5lib/cmake/KSMServerDBusInterface/
%_K5lib/cmake/Lib*/
%_K5dbus_iface/*.xml
#%_K5data/kdevappwizard/templates/*

%files -n %libkworkspace5
%_K5lib/libkworkspace5.so.*
%_K5lib/libkworkspace5.so.%kworkspace5_sover
%files -n %libplasma_geolocation_interface
%_K5lib/libplasma-geolocation-interface.so.*
%_K5lib/libplasma-geolocation-interface.so.%plasma_geolocation_interface_sover
%files -n %libtaskmanager
%_K5lib/libtaskmanager.so.*
%_K5lib/libtaskmanager.so.%taskmanager_sover
%files -n %libweather_ion
%_K5lib/libweather_ion.so.*
%_K5lib/libweather_ion.so.%weather_ion_sover
%files -n %libcolorcorrect
%_K5lib/libcolorcorrect.so.*
%_K5lib/libcolorcorrect.so.%colorcorrect_sover
%files -n %libnotificationmanager
%_K5lib/libnotificationmanager.so.*
%_K5lib/libnotificationmanager.so.%notificationmanager_sover
%files -n %libkfontinst
%_K5lib/libkfontinst.so.*
%_K5lib/libkfontinst.so.%kfontinst_sover
%files -n %libkfontinstui
%_K5lib/libkfontinstui.so.*
%_K5lib/libkfontinstui.so.%kfontinstui_sover
%files -n %libkrdb
%_K5lib/libkrdb.so.*
%_K5lib/libkrdb.so.%krdb_sover


%changelog
