%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec
%define rdn_name net.poedit.Poedit

%def_with cpprest
%def_without cld2

Name: poedit
Version: 3.0
Release: alt1

Summary: Cross-platform translation files editor
Summary(ru_RU.UTF-8): Кроссплатформенный редактор файлов переводов
Group: Editors
License: MIT
Url: http://www.poedit.net/

%if_disabled snapshot
Source: https://github.com/vslavik/%name/releases/download/v%version-oss/%name-%version.tar.gz
%else
Vcs: https://github.com/vslavik/poedit.git
Source: %name-%version.tar
%endif
Source1: README.md.%name
Patch: %name-3.0-up-HEAD.patch

ExcludeArch: armh

Requires: gettext-tools

%define cpprest_ver 2.5
# /deps/wx/include/wx/version.h 3.1.6
# with our 3.1.5 poedit segfaults
%define wxgtk_ver 3.0.3-alt9
%define boost_ver 1.60

Requires: libwxGTK3.0 >= %wxgtk_ver

BuildPreReq: desktop-file-utils libappstream-glib-devel
BuildRequires: gcc-c++ libwxGTK3.0-devel >= %wxgtk_ver libdb4_cxx-devel libgtkspell3-devel
BuildRequires: libicu-devel liblucene++-devel libpugixml-devel
BuildRequires: boost-locale-devel >= %boost_ver zlib-devel
%{?_with_cpprest:BuildRequires: libcpprest-devel >= %cpprest_ver libsecret-devel}
%{?_with_cld2:BuildRequires: libcld2-devel}

%description
This program is GUI frontend to GNU Gettext utilities and catalogs
editor/source code parser. It helps with translating application into
another language. For details on principles of the solution used, see
GNU Gettext documentation or wxWindows' wxLocale class reference.

%description -l ru_RU.UTF-8
Эта программа является оболочкой для утилит GNU Gettext. С её помощью
удобно переводить сообщения приложений на разные языки. Более подробно
принципы работы описаны в документации для GNU Gettext и класса
wxLocale библиотеки wxWindows.

%prep
%setup
%patch -p1
[ ! -f README.md ] && cp %SOURCE1 README.md

%build
%configure \
	%{subst_with cpprest} \
	%{subst_with cld2}
%make_build

%install
%makeinstall_std
rm -f %buildroot/%_iconsdir/hicolor/icon-theme.cache
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README*
%_bindir/%name
%_man1dir/%name.1.*
%_datadir/%name/
%_desktopdir/%rdn_name.desktop
%_desktopdir/net.poedit.PoeditURI.desktop
%_iconsdir/hicolor/*x*/*/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_datadir/metainfo/%rdn_name.appdata.xml

%changelog
