%define ver_major 40
%define xdg_name org.gnome.Polari
%define mozjs_ver 78

Name: polari
Version: %ver_major.1
Release: alt1

Summary: Internet Relay Chat client for GNOME
License: GPLv2+
Group: Networking/Chat
Url: https://wiki.gnome.org/Apps/Polari

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: libgjs
Requires: telepathy-logger
Requires: telepathy-mission-control
Requires: telepathy-idle

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Gspell)
Requires: typelib(Gtk)
Requires: typelib(Pango)
Requires: typelib(PangoCairo)
Requires: typelib(Polari)
Requires: typelib(Secret)
Requires: typelib(Soup)
Requires: typelib(TelepathyGLib)
Requires: typelib(TelepathyLogger)
Requires: typelib(WebKit2)

%set_typelibdir %_libdir/%name/girepository-1.0
%define gtk_ver 3.22.0
%define gspell_ver 1.3.2
%define gjs_ver 1.58.0

BuildRequires(pre): meson rpm-build-gir
BuildRequires: gtk-doc yelp-tools
BuildRequires: desktop-file-utils libappstream-glib-devel
BuildRequires: libgjs-devel >= %gjs_ver  %_bindir/js%mozjs_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libtelepathy-glib-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libsecret-gir-devel libsoup-gir-devel libgspell-gir-devel >= %gspell_ver
BuildRequires: libtelepathy-glib-gir-devel libtelepathy-logger-gir-devel

%description
Polari is a simple IRC Client that is designed to integrate seamlessly
with GNOME 3 Desktop.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name %xdg_name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_datadir/%name/
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Polari.service
%_datadir/telepathy/clients/Polari.client
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS


%changelog
