%def_enable snapshot
%define _name portaudio
%def_enable docs

Name: %{_name}2
Version: 19
Release: alt7

Summary: PortAudio is a free, cross platform, open-source, audio I/O library
License: BSD
Group: System/Libraries
Url: http://www.portaudio.com/

%if_disabled snapshot
Source: http://www.portaudio.com/archives/pa_stable_v190600_20161030.tgz
%else
#VCS: https://git.assembla.com/portaudio.git
Source: %_name-%version.tar
%endif

# Automatically added by buildreq on Mon Sep 19 2011
BuildRequires: gcc-c++ libalsa-devel libjack-devel
%{?_enable_docs:BuildRequires: doxygen graphviz}

%description
PortAudio is a free, cross platform, open-source, audio I/O
library. It lets you write simple audio programs in 'C' that will
compile and run on many platforms including Windows, Macintosh
(8,9,X), Unix (OSS), SGI, and BeOS. PortAudio is intended to
promote the exchange of audio synthesis software between
developers on different platforms, and was recently selected as
the audio component of a larger PortMusic project that includes
MIDI and sound file support.

PortAudio provides a very simple API for recording and/or playing
sound using a simple callback function. Example programs are
included that synthesize sine waves and pink noise, perform fuzz
distortion on a guitar, list available audio devices, etc.

%package -n lib%name
Summary: PortAudio is a free, cross platform, open-source, audio I/O library
Group: System/Libraries

%description -n lib%name
PortAudio is a free, cross platform, open-source, audio I/O
library. It lets you write simple audio programs in 'C' that will
compile and run on many platforms including Windows, Macintosh
(8,9,X), Unix (OSS), SGI, and BeOS. PortAudio is intended to
promote the exchange of audio synthesis software between
developers on different platforms, and was recently selected as
the audio component of a larger PortMusic project that includes
MIDI and sound file support.

PortAudio provides a very simple API for recording and/or playing
sound using a simple callback function. Example programs are
included that synthesize sine waves and pink noise, perform fuzz
distortion on a guitar, list available audio devices, etc.

%package -n lib%name-devel
Summary: Static library and header files for the PortAudio library
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libportaudio-devel

%description -n lib%name-devel
PortAudio is a free, cross platform, open-source, audio I/O
library. It lets you write simple audio programs in 'C' that will
compile and run on many platforms including Windows, Macintosh
(8,9,X), Unix (OSS), SGI, and BeOS. PortAudio is intended to
promote the exchange of audio synthesis software between
developers on different platforms, and was recently selected as
the audio component of a larger PortMusic project that includes
MIDI and sound file support.

PortAudio provides a very simple API for recording and/or playing
sound using a simple callback function. Example programs are
included that synthesize sine waves and pink noise, perform fuzz
distortion on a guitar, list available audio devices, etc.

This package contains the static PortAudio library and its header
files.

%prep
%setup -n portaudio%{?_enable_snapshot:-%version}
sed -i '/^Libs:/s/ @/\nLibs.private: @/
        s/^\(Requires:\)/\1 alsa/' portaudio-2.0.pc.in

%build
%autoreconf
%configure --disable-static --enable-cxx
%make_build lib/libportaudio.la
%make_build
%{?_enable_docs:doxygen}

%install
%makeinstall_std

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%doc README.txt
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%doc README.txt
%{?_enable_docs:%doc doc/html}

%changelog
