%define pg_ver 10
%def_with jit

Name: postgresql%pg_ver-pg_partman
Version: 4.7.4
Release: alt1

Summary: pg_partman is an extension to create and manage both time-based and serial-based table partition sets.
License: PostgreSQL
Group: Databases
Url: https://badge.fury.io/pg/pg_partman

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3

# Automatically added by buildreq on Sat May 18 2019
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 python-base sh4
BuildRequires: postgresql%pg_ver-server-devel

Requires: postgresql%pg_ver-server

%description
pg_partman is an extension to create and manage both time-based and serial-based
table partition sets. Native partitioning in PostgreSQL 10 is supported as of
pg_partman v3.0.1 and much more extensively as of 4.0.0 along with
PostgreSQL 11. Note that all the features of trigger-based partitioning
are not yet supported in native, but performance in both reads & writes is
significantly better.

%prep
%setup
%patch0 -p1

## py2 -> py3
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')
sed -i 's|#!/usr/bin/python|#!/usr/bin/python3|' \
    $(find ./ -name '*.py')
##

%build
%make

%install
%makeinstall_std

%files
%_bindir/*
%_libdir/pgsql/pg_partman_bgw.so
%if %pg_ver >= 11
%if_with jit
%_libdir/pgsql/bitcode/src/pg_partman_bgw*
%endif
%endif
%_datadir/pgsql/extension/*
%doc %_datadir/doc/postgresql/extension/*

%changelog
