%define mjversion 3.7
Name: povray
Version: %mjversion.0.8
Release: alt4

Summary: Persistence of Vision Ray Tracer (POV-Ray)
License: AGPL-3.0 and CC-BY-NC-SA-2.5 and CC-BY-SA-3.0
Group: Graphics

Url: http://www.povray.org
# VCS: https://github.com/POV-Ray/povray
Source: %name-%version.tar
Patch: %name-%version-alt.patch

Requires: %name-common

BuildRequires: gcc-c++ imake libjpeg-devel libpng-devel libtiff-devel libXpm-devel libXt-devel
BuildRequires: boost-devel boost-flyweight-devel

Summary(ru_RU.UTF-8): Трассировщик лучей POV-Ray

%description
POV-Ray is a free, full-featured ray tracer, written and
maintained by a team of volunteers on the Internet.
POV-Ray has the right balance of power and versatility
to satisfy extremely experienced and competent users, while
at the same time not being so intimidating as to completely
scare new users off.

%description -l ru_RU.UTF-8
POV-Ray - это свободный полнофункциональный трассировщик
лучей, написанный и поддерживаемый командой добровольцев
через Интернет. POV-Ray сохраняет баланс между мощностью
и гибкостью, отвечая желаниям самых опытных пользователей,
в то же время не отпугивая совсем новичков.

%package common
Group: Graphics
Summary: POV-Ray common files
Summary(ru_RU.UTF-8): Общие файлы для POV-Ray

%description common
Common files for POV-Ray: docs, textures, color maps,
scenes, scripts etc.

%description common -l ru_RU.UTF-8
Общие файлы для разных версий POV-Ray: документация,
текстуры, цветовые карты, сцены, скрипты и т.д.

%prep
%setup 
%patch -p1
%ifarch %e2k riscv64
sed -i 's,aarch64,&|riscv64|e2k,' unix/config/ax_boost_base.m4
%endif

%build
pushd unix
./prebuild.sh
popd
%configure COMPILED_BY='ALT Linux Team (http://www.altlinux.org, mailto:community@lists.altlinux.org)' --with-x --without-svga
%make_build CFLAGS=-Wno-multichar CXXFLAGS=-Wno-multichar
# Adjust bogus paths
sed -i \
  -e '/DEFAULT_DIR=/d' \
  -e 's,SYSCONFDIR=\$DEFAULT_DIR/etc,SYSCONFDIR=%{_sysconfdir},' \
  scripts/{allanim,allscene,portfolio}.sh

%install
%makeinstall_std
# remove carriage return symbols
find %buildroot%_datadir/povray-%mjversion/scripts/ -type f -print0 |\
	xargs -r0 sed -i -e 's,\r$,,g'
%files
%_bindir/povray

%files common
%config(noreplace) %_sysconfdir/%name/%mjversion/*
%dir %_datadir/%name-%mjversion
%_datadir/%name-%mjversion/*
%docdir %_defaultdocdir/%name-%mjversion
%dir %_defaultdocdir/%name-%mjversion
%_defaultdocdir/%name-%mjversion/*
%doc %_man1dir/*

%changelog
