Name: pulseaudio
Version: 17.0
Release: alt2

Summary: PulseAudio is a networked sound server
Group: System/Servers
License: LGPLv2.1
Url: http://pulseaudio.org/

Source: %name-%version-%release.tar

BuildRequires: gcc-c++ meson rpm-build-python3
BuildRequires: intltool jackit-devel libalsa-devel libasyncns-devel
BuildRequires: libavahi-devel libbluez-devel
BuildRequires: libcap-devel libdbus-devel libgdbm-devel libudev-devel
BuildRequires: libltdl7-devel libsoxr-devel
BuildRequires: libsndfile-devel libspeex-devel libspeexdsp-devel libwebrtc-audio-processing-devel
BuildRequires: libICE-devel libSM-devel libX11-devel libXtst-devel libxcbutil-devel
BuildRequires: libfftw3-devel libsbc-devel liborc-devel orc
BuildRequires: libcheck-devel libssl-devel libsystemd-devel
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel

Requires: %name-utils = %version-%release
Requires: %name-daemon = %version-%release
Requires: %name-gsettings = %version-%release

%description
PulseAudio is a networked sound server, similar in theory to the Enlightened
Sound Daemon (EsounD). PulseAudio is however much more advanced and has
numerous features.

A sound server can serve many functions:

* Software mixing of multiple audio streams, bypassing any restrictions the
hardware has.

* Network transparency, allowing an application to play back or record audio
on a different machine than the one it is running on.

* Sound API abstraction, alleviating the need for multiple backends in
applications to handle the wide diversity of sound systems out there.

* Generic hardware abstraction, giving the possibility of doing things like
individual volumes per application.

Features:

* Library licensed under LGPL and server daemon under GPL
* Extensible plugin architecture (by loading dynamic loadable modules with dlopen())
* Support for static linking of modules, allowing a single binary for all your needs
* Module autoloading
* Support for more than one sink/source
* Good low latency behaviour
* Very accurate latency measurement for playback and recording.
* Client side latency interpolation
* Embedabble into other software (the core is available as C library)
* Completely asynchronous C API, complemented by two synchronous variants for
  simple use in synchronous applications
* Simple command line interface for reconfiguring the daemon while running
* Flexible, implicit sample type conversion and resampling
* "Zero-Copy" architecture
* May be used to combine multiple sound cards to one (with sample rate adjustment)
* Ability to fully synchronize multiple playback streams

This virtual package contains pulseaudio daemon and utilities.

%package utils
Summary: PulseAudio client side utilities
Group: Sound
Requires: lib%name = %version-%release
Conflicts: %name-daemon < 17.0-alt1

%package qpaeq
Summary: PulseAudio equalizer interface
Group: Sound
Requires: lib%name = %version-%release

%package daemon
Summary: PulseAudio daemon
Group: Sound
PreReq: shadow-utils
Provides: pulseaudio-bluez = %version-%release
Obsoletes: pulseaudio-bluez

%package system
Summary: Pulseaudio system daemon
Group: Sound
Requires: pulseaudio-daemon = %version-%release

%package gsettings
Summary: PulseAudio -- gnome-related part
Group: Sound
Requires: %name-daemon = %version-%release
Provides: %name-gconf = %version-%release
Obsoletes: %name-gconf

%package jack
Summary: PulseAudio -- JACK part
Group: Sound
Requires: %name-daemon = %version-%release

%package -n lib%name
Summary: PulseAudio shared libraries
Group: System/Libraries

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%define desc \
PulseAudio is a networked sound server, similar in theory to the Enlightened\
Sound Daemon (EsounD). PulseAudio is however much more advanced and has\
numerous features.\

%description daemon %desc
This package contains PulseAudio daemon.

%description system %desc
This package contains things needed to run PulseAudio system-wide.
See http://www.pulseaudio.org/wiki/SystemWideInstance
and especially http://www.pulseaudio.org/wiki/WhatIsWrongWithSystemMode

%description utils %desc
This package contains PulseAudio client-side utilities.

%description qpaeq %desc
This package contains PulseAudio equalizer interface.

%description gsettings %desc
This package contains gnome-related part of PulseAudio.

%description jack %desc
This package contains JACK modules of PulseAudio.

%description -n lib%name %desc
This package contains the pulseaudio shared libraries.

%description -n lib%name-devel %desc
This package contains development files for pulseaudio.

%prep
%setup
echo %version > .tarball-version

%build
%meson \
    -Ddoxygen=false \
    -Ddatabase=gdbm \
    -Daccess_group=audio \
    -Dadrian-aec=true \
    -Dwebrtc-aec=enabled \
    -Dbluez5=enabled \
    -Dbluez5-gstreamer=enabled \
    -Dgstreamer=enabled \
    -Dgsettings=enabled \
    -Djack=enabled \
    #

%meson_build

%install
%meson_install
install -pm0644 -D pulseaudio.sysconfig %buildroot%_sysconfdir/sysconfig/pulseaudio
install -pm0755 -D pulseaudio.init %buildroot%_initdir/pulseaudio
install -pm0644 -D pulseaudio.service %buildroot%_unitdir/pulseaudio.service
install -pm0644    pulseaudio.socket %buildroot%_unitdir
mkdir -p \
	%buildroot%_sysconfdir/pulse/default.pa.d \
	%buildroot%_sysconfdir/pulse/system.pa.d \
	%buildroot%_localstatedir/pulse

%find_lang %name

%define pulselibdir %_libdir/pulseaudio
%define pulsemoduledir %pulselibdir/modules

%pre system
%_sbindir/groupadd -r -f pulse &> /dev/null
%_sbindir/useradd -r -g pulse -G audio -d /run/pulse -s /dev/null \
	-c "Pulseaudio daemon" -M -n pulse &>/dev/null ||:

%post system
%post_service pulseaudio

%preun system
%preun_service pulseaudio

%set_python3_req_method strict

%files

%files daemon
%_sysconfdir/xdg/autostart/pulseaudio.desktop
%_sysconfdir/xdg/Xwayland-session.d/00-pulseaudio-x11

%dir %_sysconfdir/pulse
%dir %_sysconfdir/pulse/default.pa.d
%config(noreplace) %_sysconfdir/pulse/daemon.conf
%config(noreplace) %_sysconfdir/pulse/default.pa

/lib/udev/rules.d/90-pulseaudio.rules

%_bindir/start-pulseaudio-x11
%_bindir/pulseaudio

%_datadir/pulseaudio
%_datadir/zsh/site-functions/_pulseaudio
%_datadir/bash-completion/completions/*

%_libdir/pulseaudio/libpulsecore-17.0.so

%_libexecdir/systemd/user/pulseaudio.service
%_libexecdir/systemd/user/pulseaudio-x11.service
%_libexecdir/systemd/user/pulseaudio.socket

%dir %pulselibdir
%dir %pulsemoduledir

%pulsemoduledir/*.so

%exclude %pulsemoduledir/module-gsettings.so

%exclude %pulsemoduledir/module-jack-sink.so
%exclude %pulsemoduledir/module-jack-source.so

%_man1dir/pactl.1*
%_man1dir/pulseaudio.1*
%_man1dir/start-pulseaudio-x11.1*
%_man5dir/default.pa.5*
%_man5dir/pulse-cli-syntax.5*
%_man5dir/pulse-daemon.conf.5*

%files system
%_initdir/pulseaudio
%_unitdir/pulseaudio.service
%_unitdir/pulseaudio.socket

%config(noreplace) %_sysconfdir/sysconfig/pulseaudio
%config(noreplace) %_sysconfdir/pulse/system.pa
%config(noreplace) %_datadir/dbus-1/system.d/pulseaudio-system.conf
%dir %_sysconfdir/pulse/system.pa.d

%attr(0770,root,pulse) %dir %_localstatedir/pulse

%files utils
%_bindir/pacat
%_bindir/pacmd
%_bindir/pactl
%_bindir/padsp
%_bindir/pamon
%_bindir/paplay
%_bindir/parec
%_bindir/parecord
%_bindir/pasuspender
%_bindir/pax11publish

%_libdir/pulseaudio/libpulsedsp.so

%_man1dir/pacat.1*
%_man1dir/pacmd.1*
%_man1dir/padsp.1*
%_man1dir/pamon.1*
%_man1dir/paplay.1*
%_man1dir/parec.1*
%_man1dir/parecord.1*
%_man1dir/pasuspender.1*
%_man1dir/pax11publish.1*

%files qpaeq
%_bindir/qpaeq

%files gsettings
%dir %pulselibdir
%dir %pulsemoduledir
%_libexecdir/pulse/gsettings-helper
%pulsemoduledir/module-gsettings.so
%_datadir/GConf/gsettings/pulseaudio.convert
%_datadir/glib-2.0/schemas/org.freedesktop.pulseaudio.gschema.xml

%files jack
%dir %pulselibdir
%dir %pulsemoduledir
%pulsemoduledir/module-jack-sink.so
%pulsemoduledir/module-jack-source.so

%files -n lib%name -f %name.lang
%doc LICENSE README todo src/modules/echo-cancel/adrian-license.txt

%dir %_sysconfdir/pulse
%config(noreplace) %_sysconfdir/pulse/client.conf

%_libdir/libpulse.so.*
%_libdir/libpulse-simple.so.*
%_libdir/libpulse-mainloop-glib.so.*

%dir %_libdir/pulseaudio
%_libdir/pulseaudio/libpulsecommon-17.0.so
%_man5dir/pulse-client.conf.5*

%files -n lib%name-devel
%_libdir/lib*.so
%_libdir/cmake/PulseAudio
%_includedir/pulse
%_pkgconfigdir/*.pc
%_datadir/vala/vapi/*

%changelog
