%define _unpackaged_files_terminate_build 1
%def_without bootstrap

Name: pve-cluster
Summary: Cluster Infrastructure for PVE
Version: 7.3.3
Release: alt5
License: AGPL-3.0+
Group: System/Servers
Url: https://git.proxmox.com/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

ExclusiveArch: x86_64 aarch64
Requires: chrony ntpdate corosync fuse rrd-cached >= 1.7.2-alt3 ksmtuned openvswitch
Requires: sqlite3 vixie-cron faketime tzdata openssh-server openssh-clients

Source: %name-%version.tar
Patch: %name-%version.patch

Source3: %name.filetrigger

BuildRequires(pre): rpm-macros-systemd
BuildRequires: pve-common libcheck-devel xmlto
%if_without bootstrap
BuildRequires: pve-doc-generator
%endif
BuildRequires: pve-apiclient pve-access-control
BuildRequires: pkgconfig(libcpg) pkgconfig(libcpg) pkgconfig(libcmap) pkgconfig(libquorum) pkgconfig(libqb) pkgconfig(glib-2.0) pkgconfig(fuse) pkgconfig(sqlite3) pkgconfig(librrd)
BuildRequires: perl(ExtUtils/Embed.pm) perl(Term/ReadLine.pm) perl(Digest/HMAC_SHA1.pm) perl(XML/Parser.pm) perl(RRDs.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Net/SSLeay.pm)
BuildRequires: perl(MIME/Base32.pm) perl(Net/LDAP.pm) perl(Authen/PAM.pm) perl(UUID.pm)

%description
This package contains the Cluster Infrastructure for the PVE,
namely a distributed filesystem to store configuration data
on all nodes.

%package -n libpve-cluster-perl
Summary: Proxmox Virtual Environment cluster Perl modules.
Group: Development/Perl
Requires: rrd-cached

%description -n libpve-cluster-perl
%summary.
This package contains various cluster-related perl modules.

%package -n libpve-cluster-api-perl
Summary: Proxmox Virtual Environment cluster Perl API modules.
Group: Development/Perl
Requires: openssl rsync

%description -n libpve-cluster-api-perl
%summary.
This package contains the API2 endpoints and CLI binary 'pvecm'.

%prep
%setup
%patch -p1
%if_with bootstrap
sed -i -e '/^install:/ s/pvecm.1//' -e '/^install:/ s/datacenter.cfg.5//' -e '/^install:/ s/pvecm.bash-completion//' -e '/^install:/ s/pvecm.zsh-completion//' data/PVE/Makefile
sed -i -e '/install -D .*pvecm.1/d' -e '/install -D .*datacenter.cfg.5/d' -e '/install -m .*pvecm.bash-completion/d' -e '/install -m .*pvecm.zsh-completion/d' data/PVE/Makefile
sed -i -e '/^install:/ s/pmxcfs.8//' data/src/Makefile
sed -i -e '/install -D .*pmxcfs.8/d' data/src/Makefile
%endif

%build
%make -C data

%install
%makeinstall_std -C data/PVE/Cluster
%makeinstall_std -C data
install -pD -m644 debian/%name.service %buildroot%systemd_unitdir/%name.service
install -pD -m644 debian/sysctl.d/10-pve.conf %buildroot%_sysctldir/10-pve.conf
install -pD -m0755 %SOURCE3 %buildroot%_prefix/lib/rpm/%name.filetrigger

mkdir -p %buildroot%_sysconfdir/cron.d
touch %buildroot%_sysconfdir/cron.d/vzdump

mkdir -p %buildroot%_localstatedir/%name

mkdir -p %buildroot%_sysconfdir/network
cat << __EOF__ > %buildroot%_sysconfdir/network/interfaces
auto lo
iface lo inet loopback
__EOF__

mkdir -p %buildroot%_sysconfdir/sysconfig
cat << __EOF__ > %buildroot%_sysconfdir/sysconfig/%name
DAEMON_OPTS=""
__EOF__

%post
%post_systemd_postponed %name

%preun
%preun_systemd %name

%pre
%_sbindir/groupadd -r -f www-data 2>/dev/null ||:
%_sbindir/useradd -g www-data -c 'www-data' -d /var/www -s '/sbin/nologin' -G www-data -r www-data 2>/dev/null || :

%triggerun -- %name <= 4.0.48-alt7
if [ -L %_sysconfdir/cron.d/vzdump ]; then
	rm -f %_sysconfdir/cron.d/vzdump
fi

%files
%doc debian/copyright
%config(noreplace) %_sysconfdir/sysconfig/%name
%systemd_unitdir/%name.service
%dir %_sysconfdir/network
%ghost %_sysconfdir/network/interfaces
%ghost %_sysconfdir/cron.d/vzdump
%_sysctldir/10-pve.conf
%_bindir/create_pmxcfs_db
%_bindir/pmxcfs
%perl_vendor_autolib/PVE/IPCC
%perl_vendor_privlib/PVE/Cluster.pm
%dir %perl_vendor_privlib/PVE/Cluster
%perl_vendor_privlib/PVE/Cluster/IPCConst.pm
%perl_vendor_privlib/PVE/IPCC.pm
%dir %_localstatedir/%name
%if_without bootstrap
%_man8dir/pmxcfs.8*
%endif
%_prefix/lib/rpm/%name.filetrigger

%files -n libpve-cluster-perl
%if_without bootstrap
%_man5dir/datacenter.cfg.5*
%endif
%perl_vendor_privlib/PVE/Corosync.pm
%perl_vendor_privlib/PVE/DataCenterConfig.pm
%perl_vendor_privlib/PVE/RRD.pm
%perl_vendor_privlib/PVE/SSHInfo.pm

%files -n libpve-cluster-api-perl
%_bindir/pvecm
%if_without bootstrap
%_datadir/bash-completion/completions/pvecm
%_datadir/zsh/vendor-completions/_pvecm
%_man1dir/pvecm.1*
%endif
%perl_vendor_privlib/PVE/API2/*
%perl_vendor_privlib/PVE/CLI/*
%perl_vendor_privlib/PVE/Cluster/Setup.pm

%changelog
