%def_enable check

Name: pve-common
Summary: PVE base library
Version: 7.4.2
Release: alt8
License: AGPL-3.0+
Group: Development/Perl
Url: https://git.proxmox.com/

Source: %name-%version.tar

ExclusiveArch: x86_64 aarch64

BuildRequires: perl-ph
BuildRequires: perl(IO/Socket/IP.pm)
BuildRequires: perl(Filesys/Df.pm)
BuildRequires: perl(URI/Escape.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(String/ShellQuote.pm)
BuildRequires: perl(IO/AtomicFile.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl(Devel/Cycle.pm)
BuildRequires: perl(Net/IP.pm)
BuildRequires: perl(Net/DBus.pm)
BuildRequires: perl(Pod/Parser.pm)
BuildRequires: perl(Clone.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(Linux/Inotify2.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(MIME/Base32.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm)
BuildRequires: perl(Crypt/OpenSSL/RSA.pm)
BuildRequires: perl(Date/Parse.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(HTTP/Daemon.pm)
BuildRequires: perl(CPAN/Meta/YAML.pm)
BuildRequires: perl(Net/LDAP.pm)
BuildRequires: perl(PVE/RS/CalendarEvent.pm)
BuildRequires: perl(AnyEvent.pm)
# alt regressive tests
BuildRequires: perl(TAP/Harness.pm)
BuildRequires: perl(Test/MockModule.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(NetAddr/IP.pm)

%description
This package contains the base library used by other PVE components.

%prep
%setup -q -n %name-%version
sed -i 's|Proxmox VE|PVE|' src/PVE/Tools.pm

%install
cd src
%make DESTDIR=%buildroot install
cd ..
install -pD -m0755 pve-etcnet-to-network %buildroot%_sbindir/pve-etcnet-to-network
install -pD -m0755 pve-rebuild-interfaces-cfg %buildroot%_sbindir/pve-rebuild-interfaces-cfg

%if_enabled check
%check
# upstream tests
make -C test check
# etcnet tests
./runtests.pl
%endif

%post
# Replace 'allow-ovs' with 'auto' in /etc/network/interfaces
# for ifupdown2 on upgrade
if [ "$1" -eq 2 ]; then
    %_sbindir/pve-rebuild-interfaces-cfg
fi

%files
%doc debian/copyright
%_sbindir/pve-etcnet-to-network
%_sbindir/pve-rebuild-interfaces-cfg
%perl_vendor_privlib/PVE

%changelog
