%define _unpackaged_files_terminate_build 1
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define rname lxc

Name: pve-%rname
Version: 5.0.2
Release: alt1
Summary: Linux containers userspace tools
Group: System/Configuration/Other
License: LGPL-2.1+
URL: https://linuxcontainers.org/

ExclusiveArch: x86_64 aarch64

Source: %name-%version.tar
Source2: config.tar
Source99: debian.tar
Patch: %name-%version.patch

Requires: lxcfs
Requires: criu >= 3.15
Requires: rsync wget
Requires: iproute2 iptables iptables-ipv6
Conflicts: %rname %rname-libs liblxc1 %rname-core %rname-net %rname-runtime
Provides: %rname-pve = %EVR

BuildRequires(pre): meson >= 0.61
BuildRequires: docbook2X
BuildRequires: libcap-devel libseccomp-devel libselinux-devel libssl-devel
BuildRequires: bash-completion
BuildRequires: pkgconfig(systemd)

%description
Containers provides resource management through control groups and
resource isolation through namespaces. The linux containers, lxc, aims
to use these new functionalities to provide an userspace container
object which provides full resource isolation and resource control for
an applications or a system.

%add_findreq_skiplist %_datadir/%rname/lxc-patch.py
%add_findreq_skiplist %_datadir/%rname/templates/*

%prep
%setup
mkdir debian
tar -xf %SOURCE99 -C debian --strip-components 1
tar -xf %SOURCE2 -C config --strip-components 1

%patch -p1

for p in `cat debian/patches/series`; do
    patch -p1 < debian/patches/$p
done

%build
%meson \
    -Ddistrosysconfdir='/etc/sysconfig' \
    -Dinit-script=systemd \
    -Dapparmor=false \
    -Dselinux=true \
    -Dseccomp=true \
    -Dexamples=false \
    -Dcgroup-pattern='lxc/%%n'

%meson_build

%install
%meson_install

mkdir -p %buildroot%_datadir/lxc/config
for i in config/*.conf.in; do
	sed -e "s|@LXCTEMPLATECONFIG@|%_datadir/lxc/config|g" $i > %buildroot%_datadir/lxc/${i%%.in};
done

# cleanup
rm -fr %buildroot%_libexecdir/%rname/%rname-apparmor-load
rm -f %buildroot%_datadir/lxc/lxc-patch.py
rm -fr %buildroot%_includedir
rm -f %buildroot%_libdir/liblxc.so
rm -f %buildroot%_libdir/liblxc.a
rm -fr %buildroot%_pkgconfigdir
rm -fr %buildroot%_mandir/{ja,ko}

%post
usermod --add-subgids 100000-165535 --add-subuids 100000-165535 root ||:

%files
%config(noreplace) %_sysconfdir/sysconfig/%rname
%dir %_sysconfdir/%rname
%config(noreplace) %_sysconfdir/%rname/default.conf
%_datadir/bash-completion/completions/*
%_unitdir/*.service
%_bindir/%rname-*
%_sbindir/init.%rname
%_libexecdir/%rname
%_libdir/%rname
%_libdir/*.so.*
%_datadir/%rname
%_man1dir/*.1*
%_man5dir/*.5*
%_man7dir/*.7*

%changelog
