%global _unpackaged_files_terminate_build 1
%add_findreq_skiplist %perl_vendor_privlib/PVE/ExtMetric.pm
%add_findreq_skiplist %perl_vendor_privlib/PVE/Status/InfluxDB.pm
%add_findreq_skiplist %perl_vendor_privlib/PVE/Jobs.pm

%define ver_major 7.4
%define ver_minor 17
Name: pve-manager
Summary: The Proxmox Virtual Environment
Version: %ver_major.%ver_minor
Release: alt2
License: AGPL-3.0+ and GPLv3 and MIT and OFL-1.1
Group: System/Servers
Url: https://git.proxmox.com/
Vcs: git://git.proxmox.com/git/pve-manager.git

ExclusiveArch: x86_64 aarch64

BuildRequires(pre): rpm-macros-systemd
BuildRequires(pre): rpm-macros-javascript

Requires: cstream lzop zstd wget schedutils gdisk hdparm rsync pciutils
Requires: perl-LWP-Protocol-https
Requires: pve-common >= 7.2.6 pve-guest-common >= 4.2.1
Requires: pve-storage >= 7.2.12 pve-cluster >= 7.2.3
Requires: pve-vncterm pve-novnc >= 1.2.2 pve-spiceterm pve-xtermjs >= 4.7.1 pve-acme
Requires: pve-container >= 4.0.9 pve-firewall pve-ha-manager pve-qemu-server >= 7.2.8 pve-i18n >= 1.0.3 pve-docs
Requires: proxmox-widget-toolkit >= 3.6.0 proxmox-mini-journalreader >= 1.3.1
Requires: fonts-font-awesome javascript-extjs javascript-qrcodejs
Requires: libproxmox-rs-perl >= 0.2.0 libpve-rs-perl >= 0.7.1
Requires: perl-Net-SSLeay perl-Term-ReadLine-Gnu
Requires: librados2-perl >= 1.3.1

Source: %name-%version.tar

Source6: basealt_logo.png
Source8: basealt_favicon.ico
Source9: basealt_logo-128.png

Source10: sencha-touch.tgz

BuildRequires: pve-doc-generator >= 7.2.3 xmlto perl-Pod-Parser
BuildRequires: pve-storage >= 7.2.12 pve-cluster >= 7.2.3
BuildRequires: pve-common >= 7.2.6 pve-guest-common >= 4.2.1
BuildRequires: libpve-cluster-perl >= 6.1.6 libpve-cluster-api-perl >= 7.0.5 pve-container pve-qemu-server >= 7.2.8
BuildRequires: pve-acme pve-http-server >= 2.0.12 pve-access-control >= 7.0.2
BuildRequires: proxmox-widget-toolkit >= 3.4.9
BuildRequires: perl(AptPkg/Cache.pm) perl(File/ReadBackwards.pm) perl(Template.pm) perl(Net/DNS/Resolver.pm)
BuildRequires: unzip gnupg

%description
This package contains the PVE management tools

%prep
%setup
# sencha-touch
tar xf %SOURCE10

grep '/var/run' * -rl | while read f; do
    sed -i 's|/var/run|/run|' $f
done

%build
%make PACKAGE="pve-manager" VERSION="%ver_major-%ver_minor" PVERELEASE="%ver_major" REPOID="%release"

%install
%makeinstall_std

install -m0644 %SOURCE6 %buildroot%_datadir/%name/images/basealt_logo.png
install -m0644 %SOURCE8 %buildroot%_datadir/%name/images/favicon.ico
install -m0644 %SOURCE9 %buildroot%_datadir/%name/images/logo-128.png

# sencha-touch
mkdir -p %buildroot%_jsdir/
cp -p -r sencha-touch %buildroot%_jsdir/

# fix config backup job retention
mkdir -p %buildroot%_localstatedir/%name/jobs

mkdir -p %buildroot%_tmpfilesdir
cat << __EOF__ > %buildroot%_tmpfilesdir/%name.conf
d /run/pveproxy 0700 www-data www-data -
f /var/lock/pveproxy.lck 0644 www-data www-data
f /var/lock/spiceproxy.lck 0644 www-data www-data
__EOF__

# Cleanup
rm -rf %buildroot%_sysconfdir/apt
rm -rf %buildroot%_sysconfdir/initramfs-tools
rm -f  %buildroot%_sysconfdir/modprobe.d/pve-blacklist.conf
rm -rf %buildroot%_sysconfdir/network
rm -f  %buildroot%_unitdir/pve-daily-update.service
rm -f  %buildroot%_unitdir/pve-daily-update.timer
rm -f  %buildroot%_unitdir/pvebanner.service
rm -f  %buildroot%_unitdir/pvenetcommit.service
rm -f  %buildroot%_bindir/pvebanner
rm -f  %buildroot%_bindir/pvesubscription
rm -f  %buildroot%_bindir/pveupgrade
rm -f  %buildroot%_datadir/doc/pve-manager/aplinfo.dat
rm -f  %buildroot%_man1dir/pvesubscription.1*
rm -f  %buildroot%_man1dir/pveupgrade.1*
rm -f  %buildroot%_man1dir/pve6to7.1*
rm -f  %buildroot%_bindir/pve6to7
rm -f  %buildroot%_bindir/pve7to8
rm -f  %buildroot%_man1dir/pve7to8.1*

%post
%post_systemd_postponed pvedaemon pvestatd pveproxy spiceproxy pvescheduler

%preun
%preun_systemd pvedaemon pveproxy pvestatd spiceproxy pvescheduler

%files
%doc debian/copyright
%_datadir/doc/%name
%_datadir/bash-completion/completions/*
%_datadir/zsh/vendor-completions/*
%_sysconfdir/logrotate.d/pve
%config(noreplace) %_sysconfdir/vzdump.conf
%_unitdir/*
%_tmpfilesdir/%name.conf
%_bindir/*
%perl_vendor_privlib/PVE/*.pm
%perl_vendor_privlib/PVE/API2/*.pm
%perl_vendor_privlib/PVE/API2/Hardware
%perl_vendor_privlib/PVE/API2/Ceph
%perl_vendor_privlib/PVE/API2/Cluster
%perl_vendor_privlib/PVE/CLI/*.pm
%perl_vendor_privlib/PVE/Ceph
%perl_vendor_privlib/PVE/Jobs
%perl_vendor_privlib/PVE/Service
%perl_vendor_privlib/PVE/Status
%_datadir/pve-manager
%_localstatedir/pve-manager
%_localstatedir/vz
%attr(0770,root,www-data) %_logdir/pveproxy
%_man1dir/*
%_man8dir/*
%_jsdir/sencha-touch

%changelog
