%filter_from_requires /python2.*/d

%define prever %nil

Name: pychess
Version: 0.12.4
Release: alt3

Summary: Chess game for GNOME
License: GPLv2
Group: Games/Boards
Url: https://github.com/pychess/pychess/
Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

# Source-url: https://github.com/pychess/pychess/releases/download/%version/pychess-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: rpm-build-compat >= 1.2

# needed:
Requires: gnome-icon-theme
Requires: typelib(GtkSource) = 3.0

%add_python3_req_skip gi.repository.GdkPixbuf
%add_python3_req_skip pychess.Database
%add_python3_req_skip pychess.Database.dbwalk
%add_python3_req_skip pychess.Database.model


%description
PyChess is a GTK+ chess game for Linux. It is designed to at the same time
be easy to use, beautiful to look at, and provide advanced functions for
advanced players.

%prep
%setup -n %name-%version%{?prever}

%build
%python3_build

%install
# Fix line terminators
%__subst 's/.$//g' AUTHORS
%python3_install

#change permissions
chmod +x %buildroot%python3_sitelibdir/%name/Utils/Move.py
chmod +x %buildroot%python3_sitelibdir/%name/Players/PyChess.py
rm -rf %buildroot%_datadir/menu/

%find_lang %name

%files -f %name.lang
%doc README.md LICENSE AUTHORS
%_bindir/%name
%_datadir/%name/
%python3_sitelibdir/%name/
%python3_sitelibdir/*.egg-info
%_datadir/gtksourceview-3.0/language-specs/pgn.lang
%_datadir/appdata/pychess.appdata.xml
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_man1dir/*

%changelog
