%define descr PyTables is a package for managing hierarchical datasets and designed \
to efficiently and easily cope with extremely large amounts of data. \
\
PyTables is built on top of the HDF5 library, using the Python language \
and the NumPy package (it also supports numarray and Numeric right \
out-of-the-box). It features an object-oriented interface that, combined \
with C extensions for the performance-critical parts of the code \
(generated using Pyrex), makes it a fast, yet extremely easy to use tool \
for interactively dealing with, processing and searching very large \
amounts of data. One important feature of PyTables is that it optimizes \
memory and disk resources so that data takes much less space (specially \
if on-flight compression is used) than other solutions such as \
relational or object oriented databases.

%define oname tables

%def_enable check

#TODO: fix docs and bench

Name: py%oname
Version: 3.6.1
Release: alt6
Epoch: 1

Summary: Managing hierarchical datasets

License: MIT
Group: Development/Python3
Url: http://www.pytables.org/

# https://github.com/PyTables/PyTables.git
Source: %name-%version.tar

# Patches from Debian
Patch1: 0004-remove-gtags.patch
Patch2: 0005-Skip-index-backcompat-tests-on-bingendian.patch
Patch3: 0006-Fix-pttree.patch
Patch4: 0007-Fix-syntax-warnings.patch
Patch5: 0008-Fix-the-interpreter-name-in-examples.patch

# Patches from upstream
Patch100: upstream-pull-862.patch
Patch101: upstream-pull-866.patch

Requires: python3-module-%oname = %EVR

BuildRequires: libhdf5-devel liblzo2-devel bzlib-devel
BuildRequires: xsltproc inkscape fop
BuildRequires: java-devel-default docbook-tldp-xsl docbook-dtds
BuildRequires: libblosc-devel

%add_findreq_skiplist %python3_sitelibdir/%oname/contrib/nctoh5.py
%add_findreq_skiplist %python3_sitelibdir/%oname/contrib/make_hdf.py

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel libnumpy-py3-devel
BuildRequires: python3-module-distribute python3-module-Cython
BuildRequires: python3-module-numexpr
BuildRequires: python3-module-mock
BuildRequires: python3-module-numpy-testing

%description
%descr

%package -n python3-module-%oname
Summary: Managing hierarchical datasets (Python 3)
Group: Development/Python3
%add_python3_req_skip numarray Scientific

%description -n python3-module-%oname
%descr

This package contains python module of PyTables.

%package -n python3-module-%oname-tests
Summary: Tests and examples for PyTables (Python 3)
Group: Development/Python3
%add_python3_req_skip numarray
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
%descr

This package contains tests and examples for PyTables.

%package -n python3-module-%oname-bench
Summary: Benchmarks for PyTables (Python 3)
Group: Development/Python3
%add_python3_req_skip numarray chararray recarray recarray2 Numeric psyco
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-bench
%descr

This package contains benchmarks for PyTables.

%package doc
Summary: Documentation for PyTables
Group: Development/Documentation
BuildArch: noarch

%description doc
%descr

This package contains documentation for PyTables.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch100 -p1
%patch101 -p1

find . -type f -name '*.py' -exec \
    sed -i 's|#!/usr/bin/env python$|#!/usr/bin/env python3|' '{}' +
find . -type f -name '*.py' -exec \
    sed -i 's|#!/usr/bin/python$|#!/usr/bin/python3|' '{}' +

%build
%add_optflags -fno-strict-aliasing
export NPY_NUM_BUILD_JOBS=%__nprocs
%python3_build_debug

%install
%python3_install --root=%buildroot

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make_build SPHINXBUILD="sphinx-build-3" -C doc pickle
%make_build SPHINXBUILD="sphinx-build-3" -C doc html

cp -fR doc/build/html %buildroot%_docdir/%name/
cp -fR examples %buildroot%_docdir/%name/
cp -fR bench contrib %buildroot%_docdir/%name/

%endif

install -d %buildroot%_docdir/%name/pdf
install -p -m644 LICENSE.txt README.rst RELEASE_NOTES.txt THANKS \
    %buildroot%_docdir/%name
cp -fR LICENSES %buildroot%_docdir/%name

%check
%make check PYTHON=python3

%files
%_bindir/*

%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests/

%files doc
%_docdir/%name

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests/

%changelog
