%define oname Pyro4

%def_without check

Name:           python-module-%oname
Version:        4.75
Release:        alt3.p10.1
Summary:        Python Remote Objects
Group:          Development/Python
License:        LGPL-2.0-or-later
URL:            https://pypi.python.org/pypi/Pyro4/
BuildArch:      noarch

# https://github.com/irmen/Pyro4.git
Source: %oname-%version.tar
Patch1: %oname-alt-tune-docs.patch

BuildRequires: python-devel python-module-sphinx-devel
BuildRequires: python-module-setuptools python-module-serpent python2.7(selectors34) python2.7(wsgiref) python2.7(wsgiref.util)
%if_with check
BuildRequires: python2.7(cloudpickle) python2.7(msgpack) python2.7(dill)
%endif

%py_requires json wsgiref
%py_requires selectors34

%description
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

%if_with check
%package tests
Summary: Tests for Pyro4
Group: Development/Python
Requires: %name = %version-%release

%description tests
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains tests for Pyro4.
%endif

%package examples
Summary: Examples for Pyro4
Group: Development/Documentation
BuildArch: noarch

%description examples
Pyro is an acronym for PYthon Remote Objects. It is an advanced and
powerful Distributed Object Technology system written entirely in
Python, that is designed to be very easy to use. It resembles Java's
Remote Method Invocation (RMI). It has less similarity to CORBA - which
is a system- and language independent Distributed Object Technology and
has much more to offer than Pyro or RMI. But Pyro is small, simple and
free!

This package contains examples for Pyro4.

%prep
%setup
%patch1 -p2

%build
%python_build

%install
%python_install

%check
# remove remote tests
rm -f tests/PyroTests/test_socket.py
rm -f tests/PyroTests/test_naming.py
rm -f tests/PyroTests/test_naming2.py
python setup.py test
PYTHONPATH=%buildroot%python_sitelibdir python tests/run_testsuite.py

# remove unpackages files
rm -r %buildroot%_bindir

%files
%doc LICENSE README.md
#_bindir/*
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/test

%if_with check
%files tests
%python_sitelibdir/%oname/test
%endif

%files examples
%doc examples
%doc tests

%changelog
