%define oname babel

%def_with doc
#def_disable check

Name:    python-module-%oname
Version: 2.6.0
Release: alt4
Epoch:   1

Summary: a collection of tools for internationalizing Python applications
License: BSD
Group: Development/Python

Url: http://babel.pocoo.org/

# https://github.com/mitsuhiko/babel.git
Source: %name-%version.tar
Source1: CLDR.tar

BuildArch: noarch
BuildRequires: python-module-setuptools python-module-sphinx-devel
BuildRequires: python2-base
%{?!_without_check:%{?!_disable_check:BuildRequires: %py_dependencies setuptools.command.test pytz}}

%setup_python_module babel

BuildRequires(pre): rpm-macros-sphinx
%py_requires pytz

%description
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%prep
%setup -a1

%if_with doc
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
python2 scripts/import_cldr.py CLDR/common
%python_build

%install
%python_install
mv %buildroot%_bindir/pybabel %buildroot%_bindir/pybabel.py2

%if_with doc
%make -C docs html
%endif

%check
#python setup.py test

%files
%_bindir/pybabel.py2
%python_sitelibdir/*
%doc AUTHORS CHANGES README.rst
%if_with doc
%doc docs/_build/html
%endif

%changelog
