%define _unpackaged_files_terminate_build 1

%define oname coverage

%def_without check
%def_without doc

Name: python-module-%oname
Version: 5.3
Release: alt1.p10.2
Summary: A tool for measuring code coverage of Python programs
License: Apache-2.0
Group: Development/Python
Url: https://pypi.org/project/coverage/

# https://github.com/nedbat/coveragepy.git
Source: %name-%version.tar

%if_with doc
BuildRequires: libenchant python-module-alabaster python-module-html5lib python-module-sphinxcontrib-spelling
BuildRequires: python-module-sphinx_rtd_theme
%endif

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(eventlet)
BuildRequires: python3(flaky)
BuildRequires: python3(gevent)
BuildRequires: python3(mock)
BuildRequires: python3(PyContracts)
BuildRequires: python3(pytest-xdist)
BuildRequires: python3(tox)
BuildRequires: python3(unittest_mixins)
BuildRequires: python3-module-toml
%endif

%add_findreq_skiplist /usr/lib*/python2.7/site-packages/%oname/lab/genpy.py
%add_python_req_skip lnotab

%description
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.

%if_with doc
%package doc
Summary: Documentation for Coverage python module
Group: Development/Documentation
BuildArch: noarch

%description doc
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains documentation for Coverage.py.

%package pickles
Summary: Pickles for Coverage python module
Group: Development/Python

%description pickles
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains pickles for Coverage.py.
%endif

%package -n python3-module-%oname
Summary: A tool for measuring code coverage of Python3 programs
Group: Development/Python3
# unconditional support for coverage[toml] to make it always working
Requires: python3-module-toml

%description -n python3-module-%oname
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.

%prep
%setup

cp -a . ../python3

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

export PYTHONPATH=$PWD
%if_with doc
%make_build dochtml
%make_build pickle
%endif

pushd ../python3
%python3_build_debug
popd

%install
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/coverage %buildroot%_bindir/coverage3
ln -s coverage3 %buildroot%_bindir/python3-coverage

%python_install

install -d %buildroot%python_sitelibdir/%oname/lab
install -p -m644 lab/* %buildroot%python_sitelibdir/%oname/lab

%if_with doc
install -d %buildroot%_docdir/%name
cp -fR doc/_build/html/* %buildroot%_docdir/%name/
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
# don't freeze versions
sed -i 's/==/>=/g' tox.ini requirements/pytest.pip
export PIP_NO_INDEX=YES
# don't measure coverage of ourselves
export COVERAGE_COVERAGE=no
# run tests for Python3, Python2 needs more work
export TOXENV=py%{python_version_nodots python3}
# don't run in parallel
tox.py3 --sitepackages -v

%files
%doc CHANGES.rst README.rst
%_bindir/coverage
%_bindir/coverage2
%_bindir/coverage-%_python_version
%python_sitelibdir/%oname
%python_sitelibdir/*.egg-info
%if_with doc
%exclude %python_sitelibdir/%oname/pickle

%files doc
%_docdir/%name

%files pickles
%python_sitelibdir/%oname/pickle
%endif

%files -n python3-module-%oname
%_bindir/coverage3
%_bindir/coverage-%_python3_version
%_bindir/python3-coverage
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info

%changelog
