%define oname cryptography

Name: python-module-%oname
Version: 3.0
Release: alt1

Summary: Cryptographic recipes and primitives to Python developers.

License: %asl
Group: Development/Python
Url: https://pypi.python.org/pypi/cryptography/

Packager: Vladimir Didenko <cow@altlinux.org>

# Source-url: https://pypi.python.org/packages/source/c/cryptography/%oname-%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python rpm-build-licenses
BuildRequires: libssl-devel python-module-cffi python-module-enum34 python-module-pyasn1 python-module-setuptools
BuildRequires: python-module-asn1crypto >= 0.21.0
%if_enabled test
BuildRequires: python-module-cryptography-vectors
BuildRequires: python-module-pretend python-module-iso8601 python-module-pytz
BuildRequires: python-module-pytest >= 3.9.3
BuildRequires: python-module-hypothesis
%endif

%py_requires cffi
%py_requires enum34

%setup_python_module %oname

%description
cryptography is a package which provides cryptographic recipes and primitives to Python developers.
Our goal is for it to be your "cryptographic standard library". cryptography includes both high level
recipes, and low level interfaces to common cryptographic algorithms such as symmetric ciphers, message
digests and key derivation functions.


%prep
%setup

%build
%python_build

%install
%python_install

%if_enabled test
%check
python setup.py test
%endif


%files
%doc AUTHORS.rst  CHANGELOG.rst  CONTRIBUTING.rst  README.rst
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info

%changelog
