%define _libexecdir %_prefix/libexec
%define modname dbus-python

%def_enable python2
%def_enable check
# required dbus_py_test.so for both pythons
%{?_enable_python2:%def_disable installed_tests}
%add_findreq_skiplist %_libexecdir/installed-tests/%modname/test/*.py
%def_enable documentation

Name: python-module-dbus
Version: 1.2.16
Release: alt2

Summary: Python bindings for D-BUS library
License: MIT
Group: Development/Python
Url: http://www.freedesktop.org/wiki/Software/DBusBindings

##Source: dbus-python-%version.tar
Source: http://dbus.freedesktop.org/releases/dbus-python/dbus-python-%version.tar.gz

%define dbus_ver 1.8
%define python3_ver 3.5

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3
%{?_enable_check:BuildRequires: /proc dbus-tools dbus-tools-gui glibc-i18ndata python3-module-tappy}
%{?_enable_documentation:BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme}

%if_enabled python2
%setup_python_module dbus
Requires: dbus
Provides: %modname = %EVR
Provides: %name-data = %EVR
Obsoletes: %name-data < %version-%release

BuildRequires: autoconf-archive libdbus-devel >= %dbus_ver libgio-devel >= 2.40
BuildRequires: python-devel >= 2.7 python3-devel >= %python3_ver python-modules-unittest
BuildRequires: python-module-pygobject3 python-module-tappy
%{?_enable_documentation:BuildRequires: python-module-sphinx python-module-sphinx_rtd_theme}
%endif

%description
D-Bus python bindings for use with python programs.

%package gobject
Summary: Python bindings for D-BUS library
Group: Development/Python
Requires: python-module-dbus = %EVR

%description gobject
D-Bus bindings for use with python programs
(gobject introspection bindings).

%package -n python3-module-dbus
Summary: Python3 bindings for D-BUS library
License: MIT
Group: Development/Python3
Requires: dbus >= %dbus_ver

%description -n python3-module-dbus
D-Bus python bindings for use with python programs.

%package -n python3-module-dbus-gobject
Summary: Python3 bindings for D-BUS library
Group: Development/Python3
Requires: python3-module-dbus = %EVR

%description -n python3-module-dbus-gobject
D-Bus bindings for use with python programs
(gobject introspection bindings).

%package devel
Summary: Python bindings for D-BUS library (devel package)
Group: Development/Python
%{?_enable_python2:%py_package_provides %modname-devel = %EVR}
Provides: python3-module-dbus-devel = %EVR

%description devel
D-Bus python bindings for use with python programs.
Development package.

%package devel-doc
Summary: Development documentation for %modname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
Development documentation for %modname.

%package tests
Summary: Tests for the %name package
Group: Development/Python
Requires: %name = %EVR
Requires: dbus-tools

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed python-dbus package.


%prep
%setup -n %modname-%version %{?_enable_python2:-a0
mv %modname-%version py2build}

%build
%define options %{?_enable_installed_tests:--enable-installed-tests} %{subst_enable documentation}

export am_cv_python_pythondir=%python3_sitelibdir
export am_cv_python_pyexecdir=%python3_sitelibdir
%autoreconf
%configure %options \
	PYTHON=%__python3
%make_build

%if_enabled python2
pushd py2build
# Install python code into arch-specific dir for PyQt4 (ALT#23134)
export am_cv_python_pythondir=%python_sitelibdir
export am_cv_python_pyexecdir=%python_sitelibdir

%autoreconf
%configure %options \
	PYTHON=%__python \
	PYTHON_LIBS="$(python-config --libs)"
%make_build
popd
%endif

%install
for d in {.,%{?_enable_python2:py2build}}; do
pushd $d
%makeinstall_std
popd
done

%check
%make check
%{?_enable_python2:%make check -C py2build}

%if_enabled python2
%files
%python_sitelibdir/*.so
%python_sitelibdir/dbus/
%doc AUTHORS COPYING NEWS

%exclude %python_sitelibdir/*.la
%exclude %python_sitelibdir/dbus/gobject_service.py*
%exclude %python_sitelibdir/dbus/gi_service.py*

%files gobject
%python_sitelibdir/dbus/gobject_service.py*
%python_sitelibdir/dbus/gi_service.py*
%endif

%files devel
%_includedir/dbus-1.0/dbus/dbus-python.h
%_pkgconfigdir/dbus-python.pc
%doc doc/*.txt

%files -n python3-module-dbus
%python3_sitelibdir/*.so
%python3_sitelibdir/dbus/

%exclude %python3_sitelibdir/*.la
%exclude %python3_sitelibdir/dbus/gi_service.py
%exclude %python3_sitelibdir/dbus/__pycache__/gi_service.*.pyc

%files -n python3-module-dbus-gobject
%python3_sitelibdir/dbus/gi_service.py
%python3_sitelibdir/dbus/__pycache__/gi_service.*.pyc

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%modname/
%exclude %_libexecdir/installed-tests/%modname/test/__pycache__
%_datadir/installed-tests/%modname/
%endif

%if_enabled documentation
%files devel-doc
%_docdir/%modname/
%endif


%changelog
