%define _unpackaged_files_terminate_build 1
%define oname flake8

%def_without check
%def_without python3

Name: python-module-%oname
Version: 3.7.9
Release: alt0.p10.1

Summary: Code checking using pep8 and pyflakes
Group: Development/Python
License: MIT
Url: http://pypi.python.org/pypi/flake8
# https://gitlab.com/pycqa/flake8.git
BuildArch: noarch

Source: %name-%version.tar

%if_with python3
BuildRequires(pre): rpm-build-python3
%endif
%if_with check
BuildRequires: python2.7(configparser)
BuildRequires: python2.7(coverage)
BuildRequires: python2.7(entrypoints)
BuildRequires: python2.7(functools32)
BuildRequires: python2.7(mccabe)
BuildRequires: python2.7(mock)
BuildRequires: python2.7(pycodestyle)
BuildRequires: python2.7(pyflakes)
BuildRequires: python2.7(pytest)
BuildRequires: python3(entrypoints)
BuildRequires: python3(coverage)
BuildRequires: python3(mccabe)
BuildRequires: python3(mock)
BuildRequires: python3(pycodestyle)
BuildRequires: python3(pyflakes)
BuildRequires: python3(tox)
%endif

%py_requires functools32
%py_requires mccabe
%py_requires pyflakes
%py_requires pycodestyle

%description
Flake8 is a wrapper around these tools:

- PyFlakes - pep8 - Ned's McCabe script

Flake8 runs all tools by launching the single 'flake8' script, but ignores
pep8 and PyFlakes extended options and just uses defaults. It displays the
warnings in a per-file, merged output.

It also adds a few features:

- files that contains with this header are skipped::

- lines that contains a "# NOQA" comment at the end will not issue a
warning. - a Mercurial hook.

- a McCabe complexity checker.
%if_with python3
%package -n python3-module-%oname
Summary: Code checking using pep8 and pyflakes
Group: Development/Python3
%py3_requires mccabe
%py3_requires pycodestyle
%py3_requires pyflakes

%description -n python3-module-%oname
Flake8 is a wrapper around these tools:

- PyFlakes - pep8 - Ned's McCabe script

Flake8 runs all tools by launching the single 'flake8' script, but ignores
pep8 and PyFlakes extended options and just uses defaults. It displays the
warnings in a per-file, merged output.

It also adds a few features:

- files that contains with this header are skipped::

- lines that contains a "# NOQA" comment at the end will not issue a
warning. - a Mercurial hook.

- a McCabe complexity checker.

This is version of the package running with Python 3.
%endif
%prep
%setup

%build
%python_build_debug -b build2
%if_with python3
%python3_build_debug -b build3
%endif

%install
ln -sf build2 build
%python_install
mv %buildroot%_bindir/{flake8,python2-flake8}
%if_with python3
ln -sf build3 build
%python3_install
%endif

%check
sed -i '/\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
setenv =\
    py%{python_version_nodots python}: _COV_BIN=%_bindir\/coverage\
    py%{python_version_nodots python3}: _COV_BIN=%_bindir\/coverage3\
commands_pre =\
    \/bin\/cp {env:_COV_BIN:} \{envbindir\}\/coverage\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/coverage' tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -vr

%files
%doc README.rst LICENSE
%_bindir/python2-flake8
%python_sitelibdir/flake8/
%python_sitelibdir/flake8-*.egg-info/

%if_with python3
%files -n python3-module-%oname
%doc README.rst LICENSE
%_bindir/flake8
%python3_sitelibdir/flake8/
%python3_sitelibdir/flake8-*.egg-info/
%endif

%changelog
