%def_enable snapshot

%define _name gst-python
%define ver_major 1.16
%define gst_api_ver 1.0
%define _gst_libdir %_libdir/gstreamer-%gst_api_ver

%def_disable check

%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: python-module-gst%gst_api_ver
Version: %ver_major.2
Release: alt4

Summary: GStreamer overrides for PyGobject
Group: Development/Python
License: LGPL-2.0-or-later
Url: http://gstreamer.freedesktop.org/

Provides: %_name = %version-%release
Provides: python-module-gst = %version-%release

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

BuildRequires(pre): meson rpm-build-python rpm-build-gir rpm-macros-valgrind
BuildRequires: orc liborc-test-devel  gcc-c++ gst-plugins%gst_api_ver-devel >= %version
BuildRequires: python-devel python-modules-distutils python-module-pygobject3-devel
BuildRequires: python-modules-compiler python-module-pytest
%if_enabled valgrind
BuildRequires: valgrind-tool-devel
%endif
%{?_enable_check:BuildRequires: /proc gstreamer%gst_api_ver gst-plugins-base%gst_api_ver}

%description
This package provides GStreamer overrides for PyGobject.

%prep
%setup -n %_name-%version

%build
%meson -Dpython=python2 \
    -Dlibpython-dir=%_libdir \
    -Dpygi-overrides-dir=%python_sitelibdir/gi/overrides
%meson_build

%install
%meson_install

%check
%meson_test

%files
%python_sitelibdir/gi/overrides/*
# gstreamer plugin
%exclude %_gst_libdir/libgstpython.*
%doc AUTHORS NEWS

%changelog
