%def_without bootstrap
%def_without check

%define modulename lxml

%def_without python3

Name: python-module-lxml
Version: 4.6.3.0.16.git5ecb40bc
Release: alt1.p10.1

Summary: Powerful and Pythonic XML processing library combining libxml2/libxslt with the ElementTree API.

# Source-git: https://github.com/lxml/lxml.git
Source: %name-%version.tar
Patch0: Fix-CVE-2022-2309.patch

License: BSD-3-Clause AND GPL-2.0-or-later
Group: Development/Python
URL: http://codespeak.net/lxml

BuildPreReq: libxslt-devel zlib-devel
# see doc/build.txt
BuildPreReq: python-module-Cython >= 0.18
BuildPreReq: python-modules-wsgiref
%if_without bootstrap
# Used for tests only, but depends on lxml itself,
# which is not yet built in a bootstrap environment.
BuildPreReq: python-module-cssselect
%endif

%setup_python_module lxml
%py_requires cssselect

BuildPreReq: python-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
# see doc/build.txt
BuildPreReq: python3-module-Cython >= 0.18
BuildPreReq: python3-devel
%if_without bootstrap
# Used for tests only, but depends on lxml itself,
# which is not yet built in a bootstrap environment.
BuildPreReq: python3-module-cssselect
%endif

%add_python3_req_skip etree
%endif

%description
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

%if_with python3
%package -n python3-module-%modulename
Summary: XML processing library combining libxml2/libxslt with the ElementTree API (Python 3)
Group: Development/Python3
%py3_requires cssselect
# Prepare for the future default method (to test the result earlier):
%python3_req_hier

%description -n python3-module-%modulename
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

This is module for use with Python 3.
%endif


%package doc
Summary: Documentation for lxml
Group: Development/Documentation
BuildArch: noarch

%description doc
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

This package contains documentation for lxml.

%prep
%setup
%patch0 -p1
%if_with python3
cp -a . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8
# see Makefile
%python_build_debug --with-cython
%if_with python3
pushd ../python3
sed -i 's|/usr/bin/env python.*|/usr/bin/env python3|' \
	update-error-constants.py test.py
sed -i 's|/usr/bin/python|/usr/bin/python3|' \
	doc/rest2latex.py doc/rest2html.py
%python3_build --with-cython
popd
%endif

%install
export LC_ALL=en_US.UTF-8
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if_with check
%check
export LC_ALL=en_US.UTF-8

# see Makefile
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ;
CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ;
FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ;
cp -l build/lib.linux-*/lxml/*.so src/lxml/
python2 test.py -p -v
PYTHONPATH=src python2 src/lxml/tests/selftest.py
PYTHONPATH=src python2 src/lxml/tests/selftest2.py
%if_with python3
pushd ../python3
cp -l build/lib.linux-*/lxml/*.so src/lxml/
python3 test.py -p -v
PYTHONPATH=src python3 src/lxml/tests/selftest.py
PYTHONPATH=src python3 src/lxml/tests/selftest2.py
popd
%endif
%endif

%files
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%modulename
%python3_sitelibdir/*
%endif

%files doc
%doc doc samples

%changelog
