%define _unpackaged_files_terminate_build 1
%define oname pexpect

# some tests cant spawn python
%def_without check

Name: python-module-%oname
Version: 4.6
Release: alt4

Summary: Pexpect is a pure Python Expect. It allows easy control of other applications
License: Python Software Foundation License
Group: Development/Python
# Source-git: https://github.com/pexpect/pexpect.git
Url: https://pypi.python.org/pypi/pexpect

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-objects.inv
BuildRequires: python-module-ptyprocess

%if_with check
BuildRequires: /dev/pts
BuildRequires: man-db
BuildRequires: openssl
BuildRequires: python-module-pytest
BuildRequires: python-module-pyte
%endif

BuildArch: noarch
Obsoletes: %oname < 0.999-alt6
Provides: %oname

%add_findreq_skiplist %python_sitelibdir/%oname/_async.py

%description
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
This package contains documentation for %oname.

%package pickles
Summary: Pickles for Pexpect
Group: Development/Python

%description pickles
Pexpect is a pure Python module for spawning child applications; controlling
them; and responding to expected patterns in their output. Pexpect works like
Don Libes' Expect. Pexpect allows your script to spawn a child application and
control it as if a human were typing commands.

This package contains pickles for Pexpect.

%prep
%setup
%patch0 -p1

# fix python shebangs
find . -type f -print0 |
   xargs -r0 grep -lZ '^#![[:space:]]*/usr/bin/.*python$' -- |
   xargs -r0 sed -E -i '1 s@^(#![[:space:]]*)/usr/bin/(env[[:space:]]+)?python$@\1%__python@' --

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build

%install
%python_install
cp -fR tests %buildroot%python_sitelibdir/pexpect/

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C doc pickle
%make -C doc html

cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
grep -rl "pexpect.spawn(.python" | xargs sed -i -E 's|(pexpect.spawn\(.)python|\1%__python|g'

export LC_ALL="en_US.UTF-8"
export PYTHONPATH=%buildroot%python_sitelibdir
%__python -m pytest -v

%files
%doc LICENSE *.rst
%python_sitelibdir/pexpect/
%python_sitelibdir/pexpect-*.egg-info/
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%files docs
%doc doc/_build/html
%doc examples

%files pickles
%python_sitelibdir/*/pickle

%changelog
