%define _unpackaged_files_terminate_build 1
%define oname pytest

%def_without check

Name: python-module-%oname
Version: 4.6.6
Release: alt2

Summary: Python test framework
License: MIT
Group: Development/Python
# Source-git: https://github.com/pytest-dev/pytest.git
Url: https://pypi.python.org/pypi/pytest

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires: python2.7(setuptools_scm)

%if_with check
BuildRequires: /dev/pts
BuildRequires: python2.7(tox)

BuildRequires: python2.7(argcomplete)
BuildRequires: python2.7(atomicwrites)
BuildRequires: python2.7(attr)
BuildRequires: python2.7(decorator)
BuildRequires: python2.7(funcsigs)
BuildRequires: python2.7(hypothesis)
BuildRequires: python2.7(mock)
BuildRequires: python2.7(more_itertools)
BuildRequires: python2.7(nose)
BuildRequires: python2.7(numpy)
BuildRequires: python2.7(py)
BuildRequires: python2.7(packaging)
BuildRequires: python2.7(pathlib2)
BuildRequires: python2.7(pexpect)
BuildRequires: python2.7(pluggy)
BuildRequires: python2.7(requests)
BuildRequires: python2.7(six)
BuildRequires: python2.7(wcwidth)

%endif

%py_requires funcsigs
%py_requires pathlib2
%py_requires py
%py_requires wcwidth

BuildArch: noarch

%description
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n pytest
Summary: Additional executable for pytest
Group: Development/Python
Requires: python-module-%oname = %EVR
# It simply has executables with the same filename:
Conflicts: python-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%prep
%setup
%patch -p1

%if_with check
# adjust timeouts for testing on aarch64/beehive
grep -qs 'child\.expect(.*)' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1
grep -qs 'child\.expect_exact([[:space:]]*$' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1
grep -qs 'testdir\.spawn_pytest([[:space:]]*$' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1

sed -i -e '/child\.expect(.*)/s/)[[:space:]]*$/, timeout=60)/g;' \
-e '/child\.expect_exact([[:space:]]*$/{$!N;s/\n\([[:space:]]*\)\(.*\)/\n\1\2,\n\1timeout=60,/g}' \
-e '/testdir\.spawn_pytest(.*)/s/)[[:space:]]*$/, expect_timeout=30)/g;' \
-e '/testdir\.spawn_pytest([[:space:]]*$/{$!N;s/\n\([[:space:]]*\)\(.*\)/\n\1\2,\n\1expect_timeout=30,/g}' \
-e 's/\([[:space:]]*\)child\.sendline(\x22p .*)$/&\n\1import time; time.sleep(child.delaybeforesend)/g' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py}
%endif

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python_install

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
%define python2_nodots py%{python_version_nodots python}
export TOXENV=%python2_nodots,%python2_nodots-pexpect
tox --sitepackages -p auto -o -v

%files
%doc AUTHORS LICENSE *.rst
%_bindir/py.test
%python_sitelibdir/pytest.py*
%python_sitelibdir/_pytest/
%python_sitelibdir/pytest-*.egg-info/

%files -n pytest
%_bindir/pytest

%changelog
