%define oname xlib

%def_without check

Name: python-module-%oname
Version: 0.26
Release: alt2

Summary: Python X Library

Group: Development/Python
License: LGPL
Url: https://github.com/python-xlib/python-xlib

Source: %name-%version.tar

BuildRequires: /usr/bin/texi2html
BuildRequires: python-devel python-module-setuptools python-module-setuptools_scm

%if_with check
BuildRequires: python-module-six
BuildRequires: python2.7(mock)
BuildRequires: python-module-pytest
%endif

%description
The Python X Library is a complete X11R6 client-side implementation,
written in pure Python. It can be used to write low-levelish X Windows
client applications in Python.

%package docs
Summary: Documentation and examples for Python X Library
Group: Development/Documentation
BuildArch: noarch

%description docs
The Python X Library is a complete X11R6 client-side implementation,
written in pure Python. It can be used to write low-levelish X Windows
client applications in Python.

This package contains documentation and examples for Python X Library.

%prep
%setup

%build
%python_build

pushd doc/html
%make SRCS=$PWD/../src TOPSRC=$PWD/../src/python-xlib.texi
popd

%install
%python_install

# hack for x86_64 build
test -d %buildroot%_libdir || mv %buildroot%prefix/lib %buildroot%_libdir || :

%check
python setup.py test
py.test -vv

%files
%doc README.rst LICENSE TODO
%python_sitelibdir/*

%files docs
%doc examples doc/html/*.html

%changelog
