%define _unpackaged_files_terminate_build 1
%define oname alembic

%def_without test

Name: python3-module-alembic
Version: 1.7.6
Release: alt1

Summary: Database migration tool for SQLAlchemy

License: MIT
Group: Development/Python3
Url: https://alembic.sqlalchemy.org
VCS: https://github.com/sqlalchemy/alembic

Source0: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildArch: noarch

Conflicts: python-module-alembic
Provides: python-module-alembic = %EVR

BuildRequires: help2man

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-mako
BuildRequires: python3-module-SQLAlchemy python3-module-setuptools
BuildRequires: python3-module-dateutil
%if_with test
BuildRequires: python3-module-pytest python3-module-nose
%endif

%description
Alembic is a new database migrations tool, written by the author of
SQLAlchemy <http://www.sqlalchemy.org>.  A migrations tool offers the
following functionality:

* Can emit ALTER statements to a database in order to change the structure
of tables and other constructs.
* Provides a system whereby "migration scripts" may be constructed; each script
indicates a particular series of steps that can "upgrade" a target database to
a new version, and optionally a series of steps that can "downgrade"
similarly, doing the same steps in reverse.
* Allows the scripts to execute in some sequential manner.

Documentation and status of Alembic is at http://readthedocs.org/docs/alembic/

%prep
%setup
%patch0 -p1

%build
%python3_build

%install
%python3_install
rm -rfv %buildroot%python3_sitelibdir/alembic/testing/

%if_with test
%check
%python3_test
%endif

%files
%doc README.rst LICENSE CHANGES docs
%_bindir/%oname
%python3_sitelibdir/*

%changelog
