%define modname arrow
%def_disable docs
#24 failed, 1674 passed, 2 xfailed, 14 errors in 20.22s
%def_disable check

Name: python3-module-%modname
Version: 1.1.1
Release: alt1

Summary: Better dates & times for Python
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/arrow/

Vcs: https://github.com/crsmithdev/arrow.git
Source: https://pypi.io/packages/source/a/%modname/%modname-%version.tar.gz

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-dateutil python3-module-nose
BuildRequires: python3-module-chai
BuildRequires: python3-module-simplejson
BuildRequires: python3-module-mock python3-module-dateparser >= 0.7.2
%{?_enable_docs:
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python3-module-sphinx python3-module-sphinx-autodoc-typehints}
%{?_enable_check:BuildRequires: python3-module-tox}

%description
Arrow is a Python library that offers a sensible, human-friendly
approach to creating, manipulating, formatting and converting dates,
times, and timestamps. It implements and updates the datetime type,
plugging gaps in functionality, and provides an intelligent module API
that supports many common creation scenarios. Simply put, it helps you
work with dates and times with fewer imports and a lot less code.

%prep
%setup -n %modname-%version

sed -i 's/pytest/py.test3/' tox.ini

%build
%python3_build_debug

%install
%python3_install

%if_enabled docs
export PYTHONPATH=%buildroot%python3_sitelibdir
SPHINXBUILD=sphinx-build-3 %make -C docs html
mkdir man
cp -fR docs/_build/html/* man/
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
tox.py3 -e py%(echo %__python3_version | tr -d .) --sitepackages -o -v

%files
%python3_sitelibdir/*
%doc *.rst LICENSE
%{?_enable_docs: man/}

%changelog
