%define _unpackaged_files_terminate_build 1
%define oname astroid

%def_with check

Name: python3-module-%oname
Version: 2.5.6
Release: alt1

Summary: Python Abstract Syntax Tree New Generation
License: LGPLv2.1+
Group: Development/Python3
# Source-git: https://github.com/PyCQA/astroid.git
Url: https://pypi.org/project/astroid

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest-runner

%if_with check
BuildRequires: python3-module-lazy-object-proxy
BuildRequires: python3-module-nose
BuildRequires: python3-module-pytest
BuildRequires: python3-module-wrapt
BuildRequires: python3-module-numpy
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-tox
BuildRequires: python3(tox_no_deps)
%endif

BuildArch: noarch

%description
The aim of this module is to provide a common base representation of python
source code. It is currently the powering pylint's capabilities.

It provides a compatible representation which comes from the _ast module. It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast. The new node classes have additional
methods and attributes for different usages. They include some support for
static inference and local name scopes. Furthermore, astroid can also build
partial trees by inspecting living objects.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install
# used only in tests, but requires Pytest
rm %buildroot%python3_sitelibdir/astroid/test_utils.py

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --no-deps -vvr -- tests -vra

%files
%doc ChangeLog README.rst
%python3_sitelibdir/astroid/
%python3_sitelibdir/astroid-*.egg-info/

%changelog
