%define  modulename authlib
%def_without test

Name:    python3-module-%modulename
Version: 0.15.3
Release: alt1

Summary: The ultimate Python library in building OAuth and OpenID Connect servers

License: BSD 3-Clause License
Group:   Development/Python3
URL:     https://authlib.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/lepture/authlib/archive/v%version.tar.gz
Source:  %modulename-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools

BuildArch: noarch

%add_python3_req_skip authlib.integrations._client
%add_python3_req_skip authlib.integrations._client.oauth_registry
%add_python3_req_skip authlib.oauth2.rfc7636.grant

%if_with test
# generated by epm --restore --dry-run from authlib/requirements-test.txt
%py3_buildrequires cryptography
%py3_buildrequires requests
%py3_buildrequires mock
%py3_buildrequires pytest
%py3_buildrequires coverage
%endif

%description
The ultimate Python library in building OAuth and OpenID Connect servers.
JWS, JWK, JWA, JWT are included.

%prep
%setup -n %modulename-%version

%build
%python3_build

%install
%python3_install
%python3_prune

%if_with test
%check
%python3_test
%endif

%files
%python3_sitelibdir/%modulename/
%python3_sitelibdir/*.egg-info/

%changelog
