%define _unpackaged_files_terminate_build 1
%define pypi_name backports-tarfile
%define ns_name backports
%define mod_name tarfile

# disable to bootstrap (backports-tarfile <=> jaraco.test)
%def_without check

Name: python3-module-%pypi_name
Version: 1.2.0
Release: alt1
Summary: Backport of CPython tarfile module
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/backports-tarfile
Vcs: https://github.com/jaraco/backports.tarfile
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: setuptools-68.2.2-py3-none-any.whl
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra testing
%endif

%description
%summary.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE2 dist/
echo "$(basename '%SOURCE2')" > dist/.wheeltracker
%pyproject_deps_resync_build
%pyproject_run -- bash -s <<-'ENDBUILD'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_deps_resync_metadata
%define __python3 %__python3_orig
ENDBUILD

%build
%pyproject_run -- bash -s <<-'ENDBUILD'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDBUILD

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc README.*
%python3_sitelibdir/%ns_name/
%python3_sitelibdir/%ns_name.%mod_name-%version.dist-info/

%changelog
