%define oname chai

Name: python3-module-%oname
Version: 1.1.2
Release: alt2
Summary: Easy to use mocking, stubbing and spying framework
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/chai

# https://github.com/agoragames/chai.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%py3_provides %oname
%add_findreq_skiplist %python3_sitelibdir/%oname/python2.py

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-pytest python3-module-sphinx

%description
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Chai provides a very easy to use api for mocking, stubbing and spying
your python objects, patterned after the Mocha library for Ruby.

This package contains documentation for %oname.

%prep
%setup

%prepare_sphinx3 docs
ln -s ../objects.inv docs/source/

%build
%python3_build

%install
%python3_install

%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/

%check
python3 setup.py test

%files
%doc CHANGELOG *.rst examples
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*

%changelog
