%define  modulename cheroot

# there is no ipv6 support on our build system and cheroot tests do not support this configuration
# ERROR: Could not find a version that satisfies the requirement pytest-cov==2.10.1
%def_disable check

Name:    python3-module-%modulename
Version: 8.5.2
Release: alt1

Summary: Cheroot is the high-performance, pure-Python HTTP server used by CherryPy
License: BSD
Group:   Development/Python
URL:     https://github.com/cherrypy/cheroot

Source: %name-%version.tar 
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools_scm
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-testmon
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-pytest-sugar
BuildRequires: python3-module-pytest-watch
BuildRequires: python3-module-jaraco.functools
BuildRequires: python3-module-trustme
BuildRequires: python3-module-requests-unixsocket
BuildRequires: python3-module-urllib3
BuildRequires: python3-module-OpenSSL
%if_enabled check
BuildRequires: python3-module-jaraco.text
BuildRequires: python3-module-jaraco.context
BuildRequires: python3-module-portend
BuildRequires: python3-module-requests_toolbelt
BuildRequires: python3-module-pytest-cov
%endif
BuildArch: noarch

%description
Cheroot is the high-performance, pure-Python HTTP server used by CherryPy.

%package tests
Summary: Tests for Cheroot
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for Cheroot

%prep
%setup
%patch0 -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%check
rm -f pyproject.toml
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -v

%files
%_bindir/cheroot
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%{modulename}*
%exclude %python3_sitelibdir/%{modulename}/test
%exclude %python3_sitelibdir/%{modulename}/testing.py

%files tests
%python3_sitelibdir/%{modulename}/test
%python3_sitelibdir/%{modulename}/testing.py

%changelog
