%define _unpackaged_files_terminate_build 1
%define modulename cherrypy

# https://github.com/cherrypy/cherrypy/issues/1973
%def_without check

Name: python3-module-%modulename
Version: 18.9.0
Release: alt1

Summary: CherryPy is a pythonic, object-oriented web development framework

License: BSD-3-Clause
Group: Development/Python3
URL: http://www.cherrypy.org
BuildArch: noarch

# git clone https://github.com/cherrypy/cherrypy
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-cheroot
BuildRequires: python3-module-portend
BuildRequires: python3-module-zc.lockfile
BuildRequires: python3-module-jaraco.collections
BuildRequires: python3-module-pytest-cov
%endif

# win32 depends on pywin32
# note: don't remove win32 module because other packages may rely on it
%add_findreq_skiplist %python3_sitelibdir/%modulename/process/win32.py

%description
Your CherryPy powered web applications are in fact stand-alone Python
applications embedding their own multi-threaded web server. You can deploy
them anywhere you can run Python applications. Apache is not required,
but it's possible to run a CherryPy application behind it.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install
mv %buildroot%_bindir/cherryd %buildroot%_bindir/cherryd3

%check
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%tox_check_pyproject

%files
%doc cherrypy/tutorial
%_bindir/cherryd3
%python3_sitelibdir/%modulename
%python3_sitelibdir/CherryPy-%version.dist-info
%exclude %python3_sitelibdir/%modulename/test

%changelog
