%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define pypi_name cleo

%def_disable check

Name: python3-module-%pypi_name
Version: 2.0.1
Release: alt0.2

Summary: Command-line interfaces Python library
License: MIT
Group: Development/Python3
Url: https://python-poetry.org/

%if_disabled snapshot
Source: https://github.com/python-poetry/cleo/archive/%version/%pypi_name-%version.tar.gz
%else
Vcs: https://github.com/python-poetry/cleo.git
Source: %pypi_name-%version.tar
%endif

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(wheel) python3(poetry-core)

%{?_enable_check:BuildRequires: python3(pytest)
BuildRequires: python3(pytest_mock)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(crashtest)
BuildRequires: python3(rapidfuzz)
BuildRequires: /usr/bin/poetry}

%description
Cleo allows you to create beautiful and testable command-line interfaces.

%prep
%setup -n %pypi_name-%version
#sed -i 's|\(crashtest = "^0.\)3.1|\14.0|' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%doc README.md CHANGELOG.md

%changelog
