%define oname combo

Name: python3-module-combo
Version: 0.1.0
Release: alt1

Summary: A Python Toolbox for Machine Learning Model Combination

Group: Development/Python3
License: MIT
Url: https://github.com/yzhao062/combo

# Source-url: https://github.com/yzhao062/combo/archive/V%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3 rpm-build-intro

# generated by 'epm restore --dry-run' from combo/requirements.txt
%py3_use joblib
%py3_use matplotlib
%py3_use numpy >= 1.13
%py3_use numba >= 0.35
# Circular dependency
# https://github.com/yzhao062/combo/issues/11
#py3_use pyod

#  python3-module-combo: Depends: python3(pyod.models.lscp) (< 0) but it is not installable
#                        Depends: python3(pyod.utils.utility) (< 0) but it is not installable
%add_python3_req_skip pyod.models.lscp pyod.utils.utility

%py3_use scipy
%py3_use scikit-learn >= 0.20

# generated by 'epm restore --dry-run' from combo/setup.py setup_requires
%py3_buildrequires setuptools >= 38.6.0

# for tests
BuildRequires: python3-module-pytest
BuildRequires: python3-module-scikit-learn-tests

%description
combo is a comprehensive Python toolbox for combining machine learning (ML) models and scores.
Model combination can be considered as a subtask of ensemble learning,
and has been widely used in real-world tasks and data science competitions like Kaggle.
combo has been used/introduced in various research works since its inception [7] [11].

combo library supports the combination of models and score from key ML libraries such as scikit-learn, xgboost, and LightGBM,
for crucial tasks including classification, clustering, anomaly detection.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install
%python3_prune
rm -rfv %buildroot/%python3_sitelibdir/examples/

%check
PYTHONPATH=$(pwd) py.test3 || echo "Test result are ignored."

%files
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-*.egg-info/

%changelog
